/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RI3AxiomImpl
implements RI3Axiom {
    private final int leftSubProperty;
    private final int rightSubProperty;
    private final int superProperty;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    RI3AxiomImpl(int leftLeftPropertyId, int leftRightPropertyId, int rightPropertyId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.leftSubProperty = leftLeftPropertyId;
        this.rightSubProperty = leftRightPropertyId;
        this.superProperty = rightPropertyId;
        this.annotations = annotations;
        this.hashCode = this.leftSubProperty + 31 * (this.rightSubProperty + 31 * (this.superProperty + 31 * this.annotations.hashCode()));
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RI3Axiom)) {
            return false;
        }
        RI3Axiom other = (RI3Axiom)obj;
        return this.getLeftSubProperty() == other.getLeftSubProperty() && this.getRightSubProperty() == other.getRightSubProperty() && this.getSuperProperty() == other.getSuperProperty() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public int getLeftSubProperty() {
        return this.leftSubProperty;
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.leftSubProperty);
        ret.add(this.rightSubProperty);
        ret.add(this.superProperty);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public int getRightSubProperty() {
        return this.rightSubProperty;
    }

    @Override
    public int getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubObjectPropertyOf*");
        sbuf.append("(");
        sbuf.append(this.getLeftSubProperty());
        sbuf.append(" ");
        sbuf.append(this.getRightSubProperty());
        sbuf.append(" ");
        sbuf.append(this.getSuperProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

