/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class RangeAxiomImpl
implements RangeAxiom {
    private final int property;
    private final int range;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    RangeAxiomImpl(int propertyId, int classId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.property = propertyId;
        this.range = classId;
        this.annotations = annotations;
        this.hashCode = this.property + 31 * (this.range + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeAxiom)) {
            return false;
        }
        RangeAxiom other = (RangeAxiom)obj;
        return this.getProperty() == other.getProperty() && this.getRange() == other.getRange() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.singleton(this.range);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.singleton(this.property);
    }

    @Override
    public int getProperty() {
        return this.property;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("RangeAxiom*");
        sbuf.append("(");
        sbuf.append(this.getProperty());
        sbuf.append(" ");
        sbuf.append(this.getRange());
        sbuf.append(")");
        return sbuf.toString();
    }
}

