/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.expressivity;

import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;

public class ExpressivityName {
    public String getName(OntologyExpressivity expr) {
        StringBuffer sbuf = new StringBuffer();
        if (this.isAL() && this.isC() && expr.hasTransitiveObjectProperty()) {
            sbuf.append("S");
        } else {
            if (this.isAL()) {
                sbuf.append("AL");
            } else if (this.isEL()) {
                sbuf.append("EL");
            }
            if (this.isC()) {
                sbuf.append("C");
            } else {
                if (this.isU()) {
                    sbuf.append("U");
                }
                if (!this.isEL() && this.isE()) {
                    sbuf.append("E");
                }
            }
        }
        if (expr.hasSubObjectPropertyOf()) {
            sbuf.append("H");
        }
        if (expr.hasNominal()) {
            sbuf.append("O");
        }
        if (expr.hasInverseObjectProperty()) {
            sbuf.append("I");
        }
        if (this.isQ()) {
            sbuf.append("Q");
        } else if (this.isN()) {
            sbuf.append("N");
        }
        if (expr.hasFunctionalObjectProperty()) {
            sbuf.append("F");
        }
        if (expr.hasSubPropertyChainOf()) {
            sbuf.append("R");
        }
        if (expr.hasDatatype()) {
            sbuf.append("(D)");
        }
        if (expr.hasTransitiveObjectProperty()) {
            sbuf.append(" [transitive]");
        }
        if (expr.hasBottom()) {
            sbuf.append(" [bottom]");
        }
        if (expr.hasIndividual()) {
            sbuf.append(" [individual]");
        }
        return sbuf.toString();
    }

    private boolean isAL() {
        return false;
    }

    private boolean isC() {
        return false;
    }

    private boolean isE() {
        return true;
    }

    private boolean isEL() {
        return true;
    }

    private boolean isN() {
        return false;
    }

    private boolean isQ() {
        return false;
    }

    private boolean isU() {
        return false;
    }
}

