/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.expressivity;

import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;
import java.util.Objects;

class NormalizedIntegerAxiomAnalyzer
implements NormalizedIntegerAxiomVisitor<Boolean>,
OntologyExpressivity {
    private boolean hasBottom = false;
    private final boolean hasDatatype = false;
    private boolean hasFunctionalObjectProperty = false;
    private final boolean hasIndividual = false;
    private final boolean hasInverseObjectProperty = false;
    private boolean hasNominal = false;
    private boolean hasReflexiveObjectProperty = false;
    private boolean hasSubObjectPropertyOf = false;
    private boolean hasSubPropertyChainOf = false;
    private boolean hasTransitiveObjectProperty = false;

    @Override
    public boolean hasBottom() {
        return this.hasBottom;
    }

    @Override
    public boolean hasDatatype() {
        this.getClass();
        return false;
    }

    @Override
    public boolean hasFunctionalObjectProperty() {
        return this.hasFunctionalObjectProperty;
    }

    @Override
    public boolean hasIndividual() {
        this.getClass();
        return false;
    }

    @Override
    public boolean hasInverseObjectProperty() {
        this.getClass();
        return false;
    }

    @Override
    public boolean hasNominal() {
        return this.hasNominal;
    }

    @Override
    public boolean hasReflexiveObjectProperty() {
        return this.hasReflexiveObjectProperty;
    }

    @Override
    public boolean hasSubObjectPropertyOf() {
        return this.hasSubObjectPropertyOf;
    }

    @Override
    public boolean hasSubPropertyChainOf() {
        return this.hasSubPropertyChainOf;
    }

    @Override
    public boolean hasTransitiveObjectProperty() {
        return this.hasTransitiveObjectProperty;
    }

    @Override
    public Boolean visit(FunctObjectPropAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasFunctionalObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(GCI0Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom |= axiom.getSubClass() == IntegerEntityManager.bottomClassId.intValue() || axiom.getSuperClass() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(GCI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom |= axiom.getLeftSubClass() == IntegerEntityManager.bottomClassId.intValue() || axiom.getRightSubClass() == IntegerEntityManager.bottomClassId.intValue() || axiom.getSuperClass() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(GCI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom |= axiom.getSubClass() == IntegerEntityManager.bottomClassId.intValue() || axiom.getClassInSuperClass() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(GCI3Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom |= axiom.getClassInSubClass() == IntegerEntityManager.bottomClassId.intValue() || axiom.getSuperClass() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(NominalAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasNominal = true;
        return true;
    }

    @Override
    public Boolean visit(RangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom |= axiom.getRange() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(RI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasReflexiveObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(RI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasSubObjectPropertyOf = true;
        return true;
    }

    @Override
    public Boolean visit(RI3Axiom axiom) {
        Objects.requireNonNull(axiom);
        if (axiom.getSuperProperty() == axiom.getLeftSubProperty() && axiom.getSuperProperty() == axiom.getRightSubProperty()) {
            this.hasTransitiveObjectProperty = true;
        } else {
            this.hasSubPropertyChainOf = true;
        }
        return true;
    }
}

