/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.xml.XMLReaderFactory;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class XMLReaderBasedParser
extends AbstractRDFParser {
    private static final Set<RioSetting<Boolean>> compulsoryXmlFeatureSettings = new HashSet<RioSetting>(Arrays.asList(XMLParserSettings.SECURE_PROCESSING, XMLParserSettings.DISALLOW_DOCTYPE_DECL, XMLParserSettings.EXTERNAL_GENERAL_ENTITIES, XMLParserSettings.EXTERNAL_PARAMETER_ENTITIES));
    private static final Set<RioSetting<Boolean>> optionalXmlFeatureSettings = new HashSet<RioSetting>(Arrays.asList(XMLParserSettings.LOAD_EXTERNAL_DTD));

    public XMLReaderBasedParser(ValueFactory f) {
        super(f);
    }

    public Collection<RioSetting<?>> getCompulsoryXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getCompulsoryXmlFeatureSettings() {
        return Collections.unmodifiableSet(compulsoryXmlFeatureSettings);
    }

    public Collection<RioSetting<?>> getOptionalXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getOptionalXmlFeatureSettings() {
        return Collections.unmodifiableSet(optionalXmlFeatureSettings);
    }

    protected XMLReader getXMLReader() throws SAXException {
        XMLReader xmlReader = this.getParserConfig().isSet(XMLParserSettings.CUSTOM_XML_READER) ? this.getParserConfig().get(XMLParserSettings.CUSTOM_XML_READER) : XMLReaderFactory.createXMLReader();
        for (RioSetting<Boolean> rioSetting : this.getCompulsoryXmlFeatureSettings()) {
            try {
                xmlReader.setFeature(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
            }
            catch (SAXNotRecognizedException e) {
                this.reportWarning(String.format("%s is not a recognized SAX feature.", rioSetting.getKey()));
            }
            catch (SAXNotSupportedException e) {
                this.reportWarning(String.format("%s is not a supported SAX feature.", rioSetting.getKey()));
            }
        }
        for (RioSetting<Boolean> rioSetting : this.getCompulsoryXmlPropertySettings()) {
            try {
                xmlReader.setProperty(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
            }
            catch (SAXNotRecognizedException e) {
                this.reportWarning(String.format("%s is not a recognized SAX property.", rioSetting.getKey()));
            }
            catch (SAXNotSupportedException e) {
                this.reportWarning(String.format("%s is not a supported SAX property.", rioSetting.getKey()));
            }
        }
        for (RioSetting<Boolean> rioSetting : this.getOptionalXmlFeatureSettings()) {
            try {
                if (!this.getParserConfig().isSet(rioSetting)) continue;
                xmlReader.setFeature(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
            }
            catch (SAXNotRecognizedException e) {
                this.reportWarning(String.format("%s is not a recognized SAX feature.", rioSetting.getKey()));
            }
            catch (SAXNotSupportedException e) {
                this.reportWarning(String.format("%s is not a supported SAX feature.", rioSetting.getKey()));
            }
        }
        for (RioSetting<Boolean> rioSetting : this.getOptionalXmlPropertySettings()) {
            try {
                if (!this.getParserConfig().isSet(rioSetting)) continue;
                xmlReader.setProperty(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
            }
            catch (SAXNotRecognizedException e) {
                this.reportWarning(String.format("%s is not a recognized SAX property.", rioSetting.getKey()));
            }
            catch (SAXNotSupportedException e) {
                this.reportWarning(String.format("%s is not a supported SAX property.", rioSetting.getKey()));
            }
        }
        return xmlReader;
    }
}

