# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class AvailableNumber(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'phone_number': 'str',
        'voice_enabled': 'bool',
        'sms_enabled': 'bool',
        'alias': 'str',
        'region': 'str',
        'country': 'str'
    }

    attribute_map = {
        'phone_number': 'phoneNumber',
        'voice_enabled': 'voiceEnabled',
        'sms_enabled': 'smsEnabled',
        'alias': 'alias',
        'region': 'region',
        'country': 'country'
    }

    def __init__(self, phone_number=None, voice_enabled=None, sms_enabled=None, alias=None, region=None, country=None, local_vars_configuration=None):  # noqa: E501
        """AvailableNumber - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._phone_number = None
        self._voice_enabled = None
        self._sms_enabled = None
        self._alias = None
        self._region = None
        self._country = None
        self.discriminator = None

        if phone_number is not None:
            self.phone_number = phone_number
        if voice_enabled is not None:
            self.voice_enabled = voice_enabled
        if sms_enabled is not None:
            self.sms_enabled = sms_enabled
        if alias is not None:
            self.alias = alias
        if region is not None:
            self.region = region
        if country is not None:
            self.country = country

    @property
    def phone_number(self):
        """Gets the phone_number of this AvailableNumber.  # noqa: E501

        The phone number, in E.164 format (+ country code and phone number: +18003608245).  # noqa: E501

        :return: The phone_number of this AvailableNumber.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this AvailableNumber.

        The phone number, in E.164 format (+ country code and phone number: +18003608245).  # noqa: E501

        :param phone_number: The phone_number of this AvailableNumber.  # noqa: E501
        :type: str
        """

        self._phone_number = phone_number

    @property
    def voice_enabled(self):
        """Gets the voice_enabled of this AvailableNumber.  # noqa: E501

        Typically set to true for all numbers.  # noqa: E501

        :return: The voice_enabled of this AvailableNumber.  # noqa: E501
        :rtype: bool
        """
        return self._voice_enabled

    @voice_enabled.setter
    def voice_enabled(self, voice_enabled):
        """Sets the voice_enabled of this AvailableNumber.

        Typically set to true for all numbers.  # noqa: E501

        :param voice_enabled: The voice_enabled of this AvailableNumber.  # noqa: E501
        :type: bool
        """

        self._voice_enabled = voice_enabled

    @property
    def sms_enabled(self):
        """Gets the sms_enabled of this AvailableNumber.  # noqa: E501

        Indicates whether the phone number can send and receive SMS messages.  # noqa: E501

        :return: The sms_enabled of this AvailableNumber.  # noqa: E501
        :rtype: bool
        """
        return self._sms_enabled

    @sms_enabled.setter
    def sms_enabled(self, sms_enabled):
        """Sets the sms_enabled of this AvailableNumber.

        Indicates whether the phone number can send and receive SMS messages.  # noqa: E501

        :param sms_enabled: The sms_enabled of this AvailableNumber.  # noqa: E501
        :type: bool
        """

        self._sms_enabled = sms_enabled

    @property
    def alias(self):
        """Gets the alias of this AvailableNumber.  # noqa: E501

        A nicely-formatted version of the phone number.  # noqa: E501

        :return: The alias of this AvailableNumber.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this AvailableNumber.

        A nicely-formatted version of the phone number.  # noqa: E501

        :param alias: The alias of this AvailableNumber.  # noqa: E501
        :type: str
        """

        self._alias = alias

    @property
    def region(self):
        """Gets the region of this AvailableNumber.  # noqa: E501

        The state or province of this phone number.  # noqa: E501

        :return: The region of this AvailableNumber.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this AvailableNumber.

        The state or province of this phone number.  # noqa: E501

        :param region: The region of this AvailableNumber.  # noqa: E501
        :type: str
        """

        self._region = region

    @property
    def country(self):
        """Gets the country of this AvailableNumber.  # noqa: E501

        The country of this phone number.  # noqa: E501

        :return: The country of this AvailableNumber.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this AvailableNumber.

        The country of this phone number.  # noqa: E501

        :param country: The country of this AvailableNumber.  # noqa: E501
        :type: str
        """

        self._country = country

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AvailableNumber):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AvailableNumber):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
