# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ProjectApprovalRule']


class ProjectApprovalRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approvals_required: Optional[pulumi.Input[int]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # gitlab\_project\_approval\_rule

        This resource allows you to create and manage multiple approval rules for your GitLab
        projects. For further information on approval rules, consult the [gitlab
        documentation](https://docs.gitlab.com/ee/api/merge_request_approvals.html#project-level-mr-approvals).

        > This feature requires a GitLab Starter account or above.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_one = gitlab.ProjectApprovalRule("example-one",
            approvals_required=3,
            group_ids=[51],
            project="5",
            user_ids=[
                50,
                500,
            ])
        example_two = gitlab.ProjectApprovalRule("example-two",
            approvals_required=1,
            group_ids=[52],
            project="5",
            user_ids=[])
        ```

        ## Import

        GitLab project approval rules can be imported using an id consisting of `project-id:rule-id`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectApprovalRule:ProjectApprovalRule example "12345:6"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs who's members can approve of the merge request
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if approvals_required is None and not opts.urn:
                raise TypeError("Missing required property 'approvals_required'")
            __props__['approvals_required'] = approvals_required
            __props__['group_ids'] = group_ids
            __props__['name'] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['user_ids'] = user_ids
        super(ProjectApprovalRule, __self__).__init__(
            'gitlab:index/projectApprovalRule:ProjectApprovalRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approvals_required: Optional[pulumi.Input[int]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'ProjectApprovalRule':
        """
        Get an existing ProjectApprovalRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs who's members can approve of the merge request
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["approvals_required"] = approvals_required
        __props__["group_ids"] = group_ids
        __props__["name"] = name
        __props__["project"] = project
        __props__["user_ids"] = user_ids
        return ProjectApprovalRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalsRequired")
    def approvals_required(self) -> pulumi.Output[int]:
        """
        The number of approvals required for this rule.
        """
        return pulumi.get(self, "approvals_required")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A list of group IDs who's members can approve of the merge request
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the approval rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or id of the project to add the approval rules.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A list of specific User IDs to add to the list of approvers.
        """
        return pulumi.get(self, "user_ids")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

