"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Campaign = exports.CampaignSignal = exports.TimeBasedCollectionScheme = exports.CollectionScheme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CollectionScheme {
    constructor() {
        this.scheme = {};
    }
    toObject() {
        return (this.scheme);
    }
}
exports.CollectionScheme = CollectionScheme;
_a = JSII_RTTI_SYMBOL_1;
CollectionScheme[_a] = { fqn: "cdk-aws-iotfleetwise.CollectionScheme", version: "0.2.7" };
class TimeBasedCollectionScheme extends CollectionScheme {
    constructor(period) {
        super();
        this.scheme = {
            timeBasedCollectionScheme: {
                periodMs: period.toMilliseconds(),
            },
        };
    }
}
exports.TimeBasedCollectionScheme = TimeBasedCollectionScheme;
_b = JSII_RTTI_SYMBOL_1;
TimeBasedCollectionScheme[_b] = { fqn: "cdk-aws-iotfleetwise.TimeBasedCollectionScheme", version: "0.2.7" };
class CampaignSignal {
    constructor(name, maxSampleCount, minimumSamplingInterval) {
        this.signal = {
            signalName: name,
            ...maxSampleCount && { maxSampleCount },
            ...minimumSamplingInterval && { minimumSamplingInterval },
        };
    }
    toObject() {
        return (this.signal);
    }
}
exports.CampaignSignal = CampaignSignal;
_c = JSII_RTTI_SYMBOL_1;
CampaignSignal[_c] = { fqn: "cdk-aws-iotfleetwise.CampaignSignal", version: "0.2.7" };
class Campaign extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.arn = '';
        this.target = {};
        this.name = props.name;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.target}`;
        this.target = props.target;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'campaignhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.target.vehicleModel.signalCatalog.lambdaLayer],
            role: this.target.vehicleModel.signalCatalog.lambdaRole,
            logRetention: this.target.vehicleModel.signalCatalog.logRetention,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
            logRetention: this.target.vehicleModel.signalCatalog.logRetention,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                campaign_name: this.name,
                signal_catalog_arn: this.target.vehicleModel.signalCatalog.arn,
                target_arn: this.target.arn,
                collection_scheme: JSON.stringify(props.collectionScheme.toObject()),
                signals_to_collect: JSON.stringify(props.signals.map(s => s.toObject())),
                auto_approve: props.autoApprove || false,
            },
        });
        resource.node.addDependency(this.target);
    }
}
exports.Campaign = Campaign;
_d = JSII_RTTI_SYMBOL_1;
Campaign[_d] = { fqn: "cdk-aws-iotfleetwise.Campaign", version: "0.2.7" };
//# sourceMappingURL=data:application/json;base64,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