import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadJobParserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag to enable setting any unset fields to their default values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/job_parser#canonicalize DataNomadJobParser#canonicalize}
    */
    readonly canonicalize?: boolean | cdktf.IResolvable;
    /**
    * Specifies the HCL definition of the job encoded in a JSON string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/job_parser#hcl DataNomadJobParser#hcl}
    */
    readonly hcl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/job_parser#id DataNomadJobParser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/job_parser nomad_job_parser}
*/
export declare class DataNomadJobParser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_job_parser";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/job_parser nomad_job_parser} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadJobParserConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadJobParserConfig);
    private _canonicalize?;
    get canonicalize(): boolean | cdktf.IResolvable;
    set canonicalize(value: boolean | cdktf.IResolvable);
    resetCanonicalize(): void;
    get canonicalizeInput(): boolean | cdktf.IResolvable | undefined;
    private _hcl?;
    get hcl(): string;
    set hcl(value: string);
    get hclInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get json(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
