import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadScalingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The scaling policy ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/scaling_policy#id DataNomadScalingPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/scaling_policy nomad_scaling_policy}
*/
export declare class DataNomadScalingPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_scaling_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/scaling_policy nomad_scaling_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadScalingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadScalingPolicyConfig);
    get enabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get max(): number;
    get min(): number;
    get policy(): string;
    private _target;
    get target(): cdktf.StringMap;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
