import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface QuotaSpecificationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this quota specification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#description QuotaSpecification#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#id QuotaSpecification#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this quota specification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#name QuotaSpecification#name}
    */
    readonly name: string;
    /**
    * limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#limits QuotaSpecification#limits}
    */
    readonly limits: QuotaSpecificationLimits[] | cdktf.IResolvable;
}
export interface QuotaSpecificationLimitsRegionLimit {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#cpu QuotaSpecification#cpu}
    */
    readonly cpu?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#memory_mb QuotaSpecification#memory_mb}
    */
    readonly memoryMb?: number;
}
export declare function quotaSpecificationLimitsRegionLimitToTerraform(struct?: QuotaSpecificationLimitsRegionLimitOutputReference | QuotaSpecificationLimitsRegionLimit): any;
export declare class QuotaSpecificationLimitsRegionLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): QuotaSpecificationLimitsRegionLimit | undefined;
    set internalValue(value: QuotaSpecificationLimitsRegionLimit | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _memoryMb?;
    get memoryMb(): number;
    set memoryMb(value: number);
    resetMemoryMb(): void;
    get memoryMbInput(): number | undefined;
}
export interface QuotaSpecificationLimits {
    /**
    * Region in which this limit has affect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#region QuotaSpecification#region}
    */
    readonly region: string;
    /**
    * region_limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification#region_limit QuotaSpecification#region_limit}
    */
    readonly regionLimit: QuotaSpecificationLimitsRegionLimit;
}
export declare function quotaSpecificationLimitsToTerraform(struct?: QuotaSpecificationLimits | cdktf.IResolvable): any;
export declare class QuotaSpecificationLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): QuotaSpecificationLimits | cdktf.IResolvable | undefined;
    set internalValue(value: QuotaSpecificationLimits | cdktf.IResolvable | undefined);
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _regionLimit;
    get regionLimit(): QuotaSpecificationLimitsRegionLimitOutputReference;
    putRegionLimit(value: QuotaSpecificationLimitsRegionLimit): void;
    get regionLimitInput(): QuotaSpecificationLimitsRegionLimit | undefined;
}
export declare class QuotaSpecificationLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: QuotaSpecificationLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): QuotaSpecificationLimitsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification nomad_quota_specification}
*/
export declare class QuotaSpecification extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_quota_specification";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/quota_specification nomad_quota_specification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QuotaSpecificationConfig
    */
    constructor(scope: Construct, id: string, config: QuotaSpecificationConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _limits;
    get limits(): QuotaSpecificationLimitsList;
    putLimits(value: QuotaSpecificationLimits[] | cdktf.IResolvable): void;
    get limitsInput(): cdktf.IResolvable | QuotaSpecificationLimits[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
