import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchedulerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config#id SchedulerConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When true, tasks may exceed their reserved memory limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config#memory_oversubscription_enabled SchedulerConfig#memory_oversubscription_enabled}
    */
    readonly memoryOversubscriptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Options to enable preemption for various schedulers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config#preemption_config SchedulerConfig#preemption_config}
    */
    readonly preemptionConfig?: {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
    * Specifies whether scheduler binpacks or spreads allocations on available nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config#scheduler_algorithm SchedulerConfig#scheduler_algorithm}
    */
    readonly schedulerAlgorithm?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config nomad_scheduler_config}
*/
export declare class SchedulerConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_scheduler_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/scheduler_config nomad_scheduler_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchedulerConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SchedulerConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memoryOversubscriptionEnabled?;
    get memoryOversubscriptionEnabled(): boolean | cdktf.IResolvable;
    set memoryOversubscriptionEnabled(value: boolean | cdktf.IResolvable);
    resetMemoryOversubscriptionEnabled(): void;
    get memoryOversubscriptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _preemptionConfig?;
    get preemptionConfig(): {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    set preemptionConfig(value: {
        [key: string]: (boolean | cdktf.IResolvable);
    });
    resetPreemptionConfig(): void;
    get preemptionConfigInput(): {
        [key: string]: boolean | cdktf.IResolvable;
    } | undefined;
    private _schedulerAlgorithm?;
    get schedulerAlgorithm(): string;
    set schedulerAlgorithm(value: string);
    resetSchedulerAlgorithm(): void;
    get schedulerAlgorithmInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
