"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.SslPolicy = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer.
 *
 * @stability stable
 */
var IpAddressType;
(function (IpAddressType) {
    IpAddressType["IPV4"] = "ipv4";
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks.
 *
 * @stability stable
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "HTTP";
    Protocol["HTTPS"] = "HTTPS";
    Protocol["TCP"] = "TCP";
    Protocol["TLS"] = "TLS";
    Protocol["UDP"] = "UDP";
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    ApplicationProtocol["HTTP"] = "HTTP";
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @stability stable
 */
var SslPolicy;
(function (SslPolicy) {
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    SslPolicy["FORWARD_SECRECY_TLS12_RES_GCM"] = "ELBSecurityPolicy-FS-1-2-Res-2020-10";
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers.
 *
 * @stability stable
 */
var TargetType;
(function (TargetType) {
    TargetType["INSTANCE"] = "instance";
    TargetType["IP"] = "ip";
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW51bXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbnVtcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUdBLElBQVksYUFVWDtBQVZELFdBQVksYUFBYTtJQUl2Qiw4QkFBYSxDQUFBO0lBS2IseUNBQXdCLENBQUE7QUFDMUIsQ0FBQyxFQVZXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBVXhCOzs7Ozs7QUFLRCxJQUFZLFFBOEJYO0FBOUJELFdBQVksUUFBUTtJQUlsQix5QkFBYSxDQUFBO0lBS2IsMkJBQWUsQ0FBQTtJQUtmLHVCQUFXLENBQUE7SUFLWCx1QkFBVyxDQUFBO0lBS1gsdUJBQVcsQ0FBQTtJQUtYLCtCQUFtQixDQUFBO0FBQ3JCLENBQUMsRUE5QlcsUUFBUSxHQUFSLGdCQUFRLEtBQVIsZ0JBQVEsUUE4Qm5COzs7Ozs7QUFLRCxJQUFZLG1CQVVYO0FBVkQsV0FBWSxtQkFBbUI7SUFJN0Isb0NBQWEsQ0FBQTtJQUtiLHNDQUFlLENBQUE7QUFDakIsQ0FBQyxFQVZXLG1CQUFtQixHQUFuQiwyQkFBbUIsS0FBbkIsMkJBQW1CLFFBVTlCOzs7Ozs7Ozs7Ozs7Ozs7QUFlRCxJQUFZLFNBc0RYO0FBdERELFdBQVksU0FBUztJQUluQixzREFBeUMsQ0FBQTtJQU16QyxtRkFBc0UsQ0FBQTtJQUt0RSwrRUFBa0UsQ0FBQTtJQUtsRSx1RUFBMEQsQ0FBQTtJQUsxRCx1RUFBMEQsQ0FBQTtJQUsxRCw2REFBZ0QsQ0FBQTtJQUtoRCx3REFBMkMsQ0FBQTtJQUszQyxnRUFBbUQsQ0FBQTtJQUtuRCx3REFBMkMsQ0FBQTtJQVEzQyx5REFBNEMsQ0FBQTtBQUM5QyxDQUFDLEVBdERXLFNBQVMsR0FBVCxpQkFBUyxLQUFULGlCQUFTLFFBc0RwQjs7Ozs7O0FBS0QsSUFBWSxVQWVYO0FBZkQsV0FBWSxVQUFVO0lBSXBCLG1DQUFxQixDQUFBO0lBS3JCLHVCQUFTLENBQUE7SUFLVCwrQkFBaUIsQ0FBQTtBQUNuQixDQUFDLEVBZlcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUFlckIiLCJzb3VyY2VzQ29udGVudCI6WyIgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIElwQWRkcmVzc1R5cGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBJUFY0ID0gJ2lwdjQnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRFVBTF9TVEFDSyA9ICdkdWFsc3RhY2snLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIFByb3RvY29sIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBIVFRQID0gJ0hUVFAnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEhUVFBTID0gJ0hUVFBTJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFRDUCA9ICdUQ1AnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBUTFMgPSAnVExTJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVURQID0gJ1VEUCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBUQ1BfVURQID0gJ1RDUF9VRFAnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gQXBwbGljYXRpb25Qcm90b2NvbCB7XG4gICAgICAgICAgICAgICAgICAgICBcbiAgSFRUUCA9ICdIVFRQJyxcblxuICAgICAgICAgICAgICAgICAgICAgIFxuICBIVFRQUyA9ICdIVFRQUydcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIFNzbFBvbGljeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUkVDT01NRU5ERUQgPSAnRUxCU2VjdXJpdHlQb2xpY3ktMjAxNi0wOCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBGT1JXQVJEX1NFQ1JFQ1lfVExTMTJfUkVTX0dDTSA9ICdFTEJTZWN1cml0eVBvbGljeS1GUy0xLTItUmVzLTIwMjAtMTAnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRk9SV0FSRF9TRUNSRUNZX1RMUzEyX1JFUyA9ICdFTEJTZWN1cml0eVBvbGljeS1GUy0xLTItUmVzLTIwMTktMDgnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBGT1JXQVJEX1NFQ1JFQ1lfVExTMTIgPSAnRUxCU2VjdXJpdHlQb2xpY3ktRlMtMS0yLTIwMTktMDgnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBGT1JXQVJEX1NFQ1JFQ1lfVExTMTEgPSAnRUxCU2VjdXJpdHlQb2xpY3ktRlMtMS0xLTIwMTktMDgnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRk9SV0FSRF9TRUNSRUNZID0gJ0VMQlNlY3VyaXR5UG9saWN5LUZTLTIwMTgtMDYnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBUTFMxMiA9ICdFTEJTZWN1cml0eVBvbGljeS1UTFMtMS0yLTIwMTctMDEnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVExTMTJfRVhUID0gJ0VMQlNlY3VyaXR5UG9saWN5LVRMUy0xLTItRXh0LTIwMTgtMDYnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVExTMTEgPSAnRUxCU2VjdXJpdHlQb2xpY3ktVExTLTEtMS0yMDE3LTAxJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgTEVHQUNZID0gJ0VMQlNlY3VyaXR5UG9saWN5LVRMUy0xLTAtMjAxNS0wNCcsXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBUYXJnZXRUeXBlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIElOU1RBTkNFID0gJ2luc3RhbmNlJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBJUCA9ICdpcCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBMQU1CREEgPSAnbGFtYmRhJyxcbn1cbiJdfQ==