import { Database } from '@aws-cdk/aws-glue-alpha';
import { Stack } from 'aws-cdk-lib';
import { SecurityGroup, Vpc } from 'aws-cdk-lib/aws-ec2';
import { CfnResource } from 'aws-cdk-lib/aws-lakeformation';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { DataProduct } from './data-product';
import { KinesisStream } from './data-streams/kinesis-stream';
import { DataTier, LakeKind, Stage } from './global/enums';
import { DataSetResult } from './global/interfaces';
import { Pipeline } from './pipeline';
export interface DataStrategyProps {
    readonly stack: Stack;
    readonly pipe: Pipeline;
    readonly product: DataProduct;
    readonly database: Database;
    readonly logBucket: Bucket;
    readonly stage: Stage;
    readonly vpc?: Vpc;
    readonly securityGroup?: SecurityGroup;
    readonly datalakeAdminRoleArn?: string;
    readonly datalakeDbCreatorRoleArn?: string;
}
export declare abstract class LakeImplStrategy {
    locationRegistry: CfnResource[];
    stageName: Stage;
    downloadLocations: {
        [schema: string]: DataSetResult;
    };
    dataStreams: {
        [schemaName: string]: KinesisStream;
    };
    protected logBucket?: Bucket;
    protected vpc?: Vpc;
    protected securityGroup?: SecurityGroup;
    protected datalakeAdminRoleArn?: string;
    protected datalakeDbCreatorRoleArn?: string;
    abstract addPipeline(stack: Stack, pipeline: Pipeline, dataProduct: DataProduct, bucketName: string): void;
    abstract lakeKind(): LakeKind;
    getDataSetBucketName(pipe: Pipeline, dataTier: DataTier): string | undefined;
    createDataProduct(props: DataStrategyProps): void;
    protected createCrawler(stack: Stack, pipe: Pipeline, product: DataProduct, bucketName: string, s3DataLFResource: CfnResource, database: Database): void;
    protected createGlueTable(stack: Stack, pipeline: Pipeline, product: DataProduct, bucketName: string): void;
    protected createPipelineResources(stack: Stack, pipeline: Pipeline, dataProduct: DataProduct, bucketName: string): void;
    private addDataStream;
    createJDBCConnection(stack: Stack, pipeline: Pipeline): void;
    createBuckets(stack: Stack, pipe: Pipeline, product: DataProduct, database: Database): void;
    private registerDataLakeLocation;
    private createDataLocationAccessPermission;
}
export declare class LakeStrategyFactory {
    static getLakeStrategy(lakeKind: LakeKind): LakeImplStrategy;
    private static strategies;
}
