import { Resource } from 'aws-cdk-lib';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import { Construct } from 'constructs';
export declare class KinesisStream extends Resource {
    readonly stream: kinesis.Stream;
    constructor(parent: Construct, name: string, props: kinesis.StreamProps);
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricGetRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricGetRecordsIteratorAgeMilliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricGetRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricGetRecordsRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricGetRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordsRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricPutRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricReadProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricWriteProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardRateExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardEventBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardEventMillisBehindLatest(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardEventRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricSubscribeToShardEventSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
