"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const kinesis = require("aws-cdk-lib/aws-kinesis");
class KinesisStream extends aws_cdk_lib_1.Resource {
    constructor(parent, name, props) {
        super(parent, name);
        this.stream = new kinesis.Stream(this, 'kinesis-stream', props);
    }
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Kinesis',
            metricName,
            dimensionsMap: {
                StreamName: this.stream.streamName,
            },
            ...props,
        });
    }
    metricGetRecordsBytes(props) {
        return this.metric('GetRecords.Bytes', props);
    }
    metricGetRecordsIteratorAgeMilliseconds(props) {
        return this.metric('GetRecords.IteratorAgeMilliseconds', props);
    }
    metricGetRecordsLatency(props) {
        return this.metric('GetRecords.Latency', props);
    }
    metricGetRecordsRecords(props) {
        return this.metric('GetRecords.Records', props);
    }
    metricGetRecordsSuccess(props) {
        return this.metric('GetRecords.Success', props);
    }
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', props);
    }
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', props);
    }
    metricPutRecordBytes(props) {
        return this.metric('PutRecord.Bytes', props);
    }
    metricPutRecordLatency(props) {
        return this.metric('PutRecord.Latency', props);
    }
    metricPutRecordSuccess(props) {
        return this.metric('PutRecord.Success', props);
    }
    metricPutRecordsBytes(props) {
        return this.metric('PutRecords.Bytes', props);
    }
    metricPutRecordsLatency(props) {
        return this.metric('PutRecords.Latency', props);
    }
    metricPutRecordsRecords(props) {
        return this.metric('PutRecords.Records', props);
    }
    metricPutRecordsSuccess(props) {
        return this.metric('PutRecords.Success', props);
    }
    metricReadProvisionedThroughputExceeded(props) {
        return this.metric('ReadProvisionedThroughputExceeded', props);
    }
    metricWriteProvisionedThroughputExceeded(props) {
        return this.metric('WriteProvisionedThroughputExceeded', props);
    }
    metricSubscribeToShardRateExceeded(props) {
        return this.metric('SubscribeToShard.RateExceeded', props);
    }
    metricSubscribeToShardSuccess(props) {
        return this.metric('SubscribeToShard.Success', props);
    }
    metricSubscribeToShardEventBytes(props) {
        return this.metric('SubscribeToShardEvent.Bytes', props);
    }
    metricSubscribeToShardEventMillisBehindLatest(props) {
        return this.metric('SubscribeToShardEvent.MillisBehindLatest', props);
    }
    metricSubscribeToShardEventRecords(props) {
        return this.metric('SubscribeToShardEvent.Records', props);
    }
    metricSubscribeToShardEventSuccess(props) {
        return this.metric('SubscribeToShardEvent.Success', props);
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.KinesisStream", version: "0.0.56" };
//# sourceMappingURL=data:application/json;base64,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