import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { GlueJob } from './glue-job';
export interface IGlueOpsProperties {
    job: GlueJob;
    jvmHeapSizeExceeding80percent?: cloudwatch.CreateAlarmOptions;
    jvmHeapSizeExceeding90percent?: cloudwatch.CreateAlarmOptions;
    metricExecutionFailure?: cloudwatch.CreateAlarmOptions;
    metricAllExecutionAttemptsFailed?: cloudwatch.CreateAlarmOptions;
}
export declare class GlueJobOps extends Construct {
    readonly job: GlueJob;
    dashboard: cloudwatch.Dashboard;
    readonly jvmHeapSizeExceeding80PercentAlarm: cloudwatch.Alarm;
    readonly jvmHeapSizeExceeding90PercentAlarm: cloudwatch.Alarm;
    readonly metricExecutionFailureAlarm: cloudwatch.Alarm;
    readonly metricAllExecutionAttemptsFailedAlarm: cloudwatch.Alarm;
    readonly alarmsSev2: cloudwatch.Alarm[];
    readonly alarmsSev3: cloudwatch.Alarm[];
    constructor(scope: Construct, id: string, props: IGlueOpsProperties);
    private addWidgets;
    private setupDashboard;
    private alarmWidget;
}
