import { IResolvable } from 'aws-cdk-lib';
import * as glue from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
export interface IGlueTableProperties {
    tableName: string;
    description: string;
    partitionKeys: Array<glue.CfnTable.ColumnProperty | IResolvable> | IResolvable;
    columns: Array<glue.CfnTable.ColumnProperty | IResolvable> | IResolvable;
    parameters: {
        [param: string]: any;
    };
    databaseName: string;
    s3Location: string;
    serializationLibrary: string;
    serdeParameters: {
        [param: string]: any;
    };
    inputFormat: string;
    outputFormat: string;
    catalogId: string;
}
export declare class GlueTable extends Construct {
    readonly table: glue.CfnTable;
    readonly tableName: string;
    constructor(scope: Construct, id: string, props: IGlueTableProperties);
}
