"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const glue = require("aws-cdk-lib/aws-glue");
const constructs_1 = require("constructs");
class GlueTable extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.tableName = props.tableName;
        this.table = new glue.CfnTable(this, `${props.tableName}-glue-table`, {
            catalogId: props.catalogId,
            databaseName: props.databaseName,
            tableInput: {
                description: props.description,
                name: props.tableName,
                tableType: 'EXTERNAL_TABLE',
                partitionKeys: props.partitionKeys,
                parameters: {
                    EXTERNAL: true,
                    has_encrypted_data: false,
                    ...props.parameters,
                },
                storageDescriptor: {
                    columns: props.columns,
                    location: props.s3Location,
                    serdeInfo: {
                        serializationLibrary: props.serializationLibrary,
                        parameters: {
                            ...props.serdeParameters,
                        },
                    },
                    inputFormat: props.inputFormat,
                    outputFormat: props.outputFormat,
                    parameters: {
                        'serialization.format': '1',
                    },
                },
            },
        });
    }
}
exports.GlueTable = GlueTable;
_a = JSII_RTTI_SYMBOL_1;
GlueTable[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.GlueTable", version: "0.0.56" };
//# sourceMappingURL=data:application/json;base64,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