import { Asset } from 'aws-cdk-lib/aws-s3-assets';
import { Construct } from 'constructs';
export declare function notUndefined<T>(obj: T | undefined): obj is T;
export interface NameBuilderParameters {
    readonly name: string;
    readonly resourceUse?: string;
    readonly stage?: string;
    readonly region?: string;
    readonly accountId?: string;
}
export declare function buildUniqueName(props: NameBuilderParameters, maxLength: number): string;
export declare function buildS3BucketName(props: NameBuilderParameters): string;
export declare function buildKinesisApplicationName(props: NameBuilderParameters): string;
export declare function buildKinesisStreamName(props: NameBuilderParameters): string;
export declare function buildQueueName(props: NameBuilderParameters): string;
export declare function buildLambdaFunctionName(props: NameBuilderParameters): string;
export declare function buildGlueJobName(props: NameBuilderParameters): string;
export declare function buildGlueCrawlerName(props: NameBuilderParameters): string;
export declare function buildGlueEndpointName(props: NameBuilderParameters): string;
export declare function buildStateMachineName(props: NameBuilderParameters): string;
export declare function buildEventRuleName(props: NameBuilderParameters): string;
export declare function buildDynamoDBTableName(props: NameBuilderParameters): string;
export declare function buildS3BucketArn(props: NameBuilderParameters): string;
export declare function buildRoleName(props: NameBuilderParameters): string;
export declare function buildRoleArn(props: NameBuilderParameters): string;
export declare function sanitizeStackName(name: string): string;
export declare function buildPolicyStatementId(name: string, service: string, accessType: string): string;
export declare function toS3Path(asset: Asset): string;
export declare function packageAsset(scope: Construct, id: string, projectRelativePath: string): Asset;
