"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageAsset = exports.toS3Path = exports.buildPolicyStatementId = exports.sanitizeStackName = exports.buildRoleArn = exports.buildRoleName = exports.buildS3BucketArn = exports.buildDynamoDBTableName = exports.buildEventRuleName = exports.buildStateMachineName = exports.buildGlueEndpointName = exports.buildGlueCrawlerName = exports.buildGlueJobName = exports.buildLambdaFunctionName = exports.buildQueueName = exports.buildKinesisStreamName = exports.buildKinesisApplicationName = exports.buildS3BucketName = exports.buildUniqueName = exports.notUndefined = void 0;
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
function notUndefined(obj) {
    return obj !== undefined;
}
exports.notUndefined = notUndefined;
function buildUniqueName(props, maxLength) {
    const baseString = [props.name, props.resourceUse, props.stage, props.region, props.accountId]
        .filter(r => r != undefined)
        .join('-')
        .substring(0, maxLength);
    return baseString.toLowerCase();
}
exports.buildUniqueName = buildUniqueName;
function buildS3BucketName(props) {
    return buildUniqueName(props, 63).replace(/[^a-z0-9\-.]/g, '-');
}
exports.buildS3BucketName = buildS3BucketName;
function buildKinesisApplicationName(props) {
    return buildUniqueName(props, 128);
}
exports.buildKinesisApplicationName = buildKinesisApplicationName;
function buildKinesisStreamName(props) {
    return buildUniqueName(props, 128);
}
exports.buildKinesisStreamName = buildKinesisStreamName;
function buildQueueName(props) {
    return buildUniqueName(props, 80);
}
exports.buildQueueName = buildQueueName;
function buildLambdaFunctionName(props) {
    return buildUniqueName(props, 64);
}
exports.buildLambdaFunctionName = buildLambdaFunctionName;
function buildGlueJobName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueJobName = buildGlueJobName;
function buildGlueCrawlerName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueCrawlerName = buildGlueCrawlerName;
function buildGlueEndpointName(props) {
    return buildUniqueName(props, 60);
}
exports.buildGlueEndpointName = buildGlueEndpointName;
function buildStateMachineName(props) {
    return buildUniqueName(props, 80);
}
exports.buildStateMachineName = buildStateMachineName;
function buildEventRuleName(props) {
    return buildUniqueName(props, 64);
}
exports.buildEventRuleName = buildEventRuleName;
function buildDynamoDBTableName(props) {
    return buildUniqueName(props, 255);
}
exports.buildDynamoDBTableName = buildDynamoDBTableName;
function buildS3BucketArn(props) {
    const bucketName = buildS3BucketName(props);
    return `arn:aws:s3:::${bucketName}`;
}
exports.buildS3BucketArn = buildS3BucketArn;
function buildRoleName(props) {
    return buildUniqueName(props, 64);
}
exports.buildRoleName = buildRoleName;
function buildRoleArn(props) {
    const roleName = buildRoleName(props);
    return `arn:aws:iam::${props.accountId}:role/${roleName}`;
}
exports.buildRoleArn = buildRoleArn;
function sanitizeStackName(name) {
    return name.replace(/[^a-zA-Z0-9]/g, '-');
}
exports.sanitizeStackName = sanitizeStackName;
function buildPolicyStatementId(name, service, accessType) {
    return `${name}-${service}-${accessType}-access`;
}
exports.buildPolicyStatementId = buildPolicyStatementId;
function toS3Path(asset) {
    return `s3://${asset.s3BucketName}/${asset.s3ObjectKey}`;
}
exports.toS3Path = toS3Path;
function packageAsset(scope, id, projectRelativePath) {
    return new aws_s3_assets_1.Asset(scope, id, { path: projectRelativePath });
}
exports.packageAsset = packageAsset;
;
//# sourceMappingURL=data:application/json;base64,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