#!/usr/bin/env python3.4
# encoding: utf-8

import ursgal
import os
import sys
import shutil


def main(database=None,ms_file=None):
    '''
    Executes a search with MSFragger Glyco

    usage:
        ./simple_example_search.py <mzml> <database>


    '''
    uc = ursgal.UController(
        profile='QExactive+',
        params={
            'database': database,
            'modifications': [
                'M,opt,any,Oxidation',        # Met oxidation
                'C,fix,any,Carbamidomethyl',  # Carbamidomethylation
            ],
            'peptide_mapper_class_version': 'UPeptideMapper_v4',
            '-xmx': '10g',
            'cpus': 4,
            'csv_filter_rules' : [
                ['Is decoy', 'equals', 'false'],
                ['PEP','lte', 0.01],
            ],
            'use_pyqms_for_mz_calculation' : False,
            'use_spectrum_charge' : False,
            'enzyme': 'trypsin',
            'percolator_post_processing': 'mix-max',
            'precursor_mass_tolerance_minus': 10,
            'precursor_mass_tolerance_plus': 10,
            'precursor_true_tolerance': 10,
            'frag_mass_tolerance': 20,
            'frag_mass_tolerance_unit': 'ppm',
            'modifications_offsets': {
                'chemical_formulas': [],
                'masses': [
                    0,
                    # 203.07937,
                    # 349.137279,
                    # 406.15874,
                    # 552.216649,
                    # 568.21156,
                    # 714.269469,
                    # 2026.68694,
                    # 2188.73976,
                    # 2350.79258,
                    # 730.26438,
                    # 876.322289,
                    # 892.3172,
                    # 1038.375109,
                    # 1054.37002,
                    # 1200.427929,
                    # 1216.42284,
                    # 1362.480749,
                    # 1378.47566,
                    # 1524.533569,
                    # 1458.44199,
                    # 1540.52848,
                    # 1686.586389,
                    # 1702.5813,
                    # 1864.63412,
                    # 1095.39657,
                    # 1241.454479,
                    # 1257.44939,
                    # 1403.507299,
                    # 1694.602716,
                    # 1549.565208,
                    # 1840.660625,
                    # 1548.544807,
                    # 1419.50221,
                    # 1565.560119,
                    # 1856.655536,
                    # 2147.750952,
                    # 1710.597627,
                    # 1581.55503,
                    # 1727.612939,
                    # 2018.708356,
                    # 1872.650447,
                    # 1298.47594,
                    # 1444.533849,
                    # 1589.571357,
                    # 1460.52876,
                    # 1606.586669,
                    # 1897.682086,
                    # 1752.644578,
                    # 1751.624177,
                    # 1622.58158,
                    # 1768.639489,
                    # 2059.734906,
                    # 2350.830322,
                    # 1914.697398,
                    # 2205.792815,
                    # 2496.888231,
                    # 2351.850724,
                    # 2642.94614,
                    # 1913.676997,
                    # 2204.772413,
                    # 1784.6344,
                    # 1930.692309,
                    # 2221.787726,
                    # 2076.750218,
                    # 2075.729817,
                    # 1946.68722,
                    # 2092.745129,
                    # 2237.782637,
                    # 1501.55531,
                    # 1647.613219,
                    # 1938.708636,
                    # 1793.671128,
                    # 1663.60813,
                    # 1809.666039,
                    # 2100.761456,
                    # 2391.856872,
                    # 1955.723948,
                    # 1954.703547,
                    # 2245.798963,
                    # 1825.66095,
                    # 1971.718859,
                    # 2262.814276,
                    # 2553.909692,
                    # 2117.776768,
                    # 2408.872185,
                    # 2263.834677,
                    # 2116.756367,
                    # 2407.851783,
                    # 1987.71377,
                    # 2133.771679,
                    # 2424.867096,
                    # 2715.962512,
                    # 3007.057929,
                    # 2279.829588,
                    # 2570.925005,
                    # 2425.887497,
                    # 2716.982914,
                    # 3008.07833,
                    # 3299.173747,
                    # 2571.945406,
                    # 2863.040823,
                    # 2278.809187,
                    # 2569.904603,
                    # 2861.00002,
                    # 2586.919916,
                    # 2878.015332,
                    # 2311.81941,
                    # 2457.877319,
                    # 2619.930139,
                    # 1704.63468,
                    # 1850.692589,
                    # 2141.788006,
                    # 2432.883422,
                    # 1996.750498,
                    # 1866.6875,
                    # 2012.745409,
                    # 2158.803318,
                    # 2157.782917,
                    # 2028.74032,
                    # 2174.798229,
                    # 2465.893646,
                    # 2756.989062,
                    # 3048.084479,
                    # 2320.856138,
                    # 2611.951555,
                    # 2466.914047,
                    # 2190.79314,
                    # 2336.851049,
                    # 2627.946466,
                    # 2482.908958,
                    # 2774.004375,
                    # 3065.099791,
                    # 2481.888557,
                    # 2772.983973,
                    # 3064.07939,
                    # 2352.84596,
                    # 2789.999286,
                    # 3081.094702,
                    # 2644.961778,
                    # 2936.057195,
                    # 2791.019687,
                    # 3082.115104,
                    # 2643.941377,
                    # 2935.036793,
                    # 3226.13221,
                    # 3517.227626,
                    # 2952.052106,
                    # 2805.994197,
                    # 2676.9516,
                    # 3114.104926,
                    # 3405.200342,
                    # 1907.71405,
                    # 2053.771959,
                    # 2069.76687,
                    # 2215.824779,
                    # 2393.87251,
                    # 2539.930419,
                    # 2555.92533,
                    # 2701.983239,
                    # 3575.269489,
                    # 2717.97815,
                    # 2864.036059,
                    # 3155.131476,
                    # 4028.417725,
                    # 3009.073567,
                    # 2110.79342,
                    # 2256.851329,
                    # 2272.84624,
                    # 2434.89906,
                    # 2580.956969,
                    # 2759.0047,
                    # 2921.05752,
                    # 3083.11034,
                    # 3229.168249,
                    # 3448.24253,
                    # 2313.87279,
                    # 2459.930699,
                    # 2475.92561,
                    # 2621.983519,
                    # 2800.03125,
                    # 2946.089159,
                    # 3432.247619],
                ],
                'glycans': [
                    # 'HexNAc(1)',
                    # 'Hex(1)HexNAc(1)',
                    # 'HexNAc(2)',
                    # 'HexNAc(1)NeuAc(1)',
                    # 'Hex(1)HexNAc(2)',
                    # 'HexNAc(3)',
                    # 'Hex(1)HexNAc(1)NeuAc(1)',
                    # 'HexNAc(2)NeuAc(1)',
                    # 'dHex(1)Hex(1)HexNAc(2)',
                    # 'Hex(2)HexNAc(2)',
                    # 'Hex(1)HexNAc(3)',
                    # 'Hex(1)HexNAc(2)NeuAc(1)',
                    # 'dHex(2)Hex(1)HexNAc(2)',
                    # 'dHex(1)Hex(2)HexNAc(2)',
                    # 'dHex(1)Hex(1)HexNAc(3)',
                    'Hex(2)HexNAc(3)',
                    # 'Hex(1)HexNAc(1)NeuAc(2)',
                    # 'Hex(1)HexNAc(4)',
                    # 'dHex(1)Hex(1)HexNAc(2)NeuAc(1)',
                    # 'Hex(2)HexNAc(2)NeuAc(1)',
                    # 'dHex(2)Hex(2)HexNAc(2)',
                    # 'Hex(1)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(1)HexNAc(3)',
                    # 'dHex(1)Hex(2)HexNAc(3)',
                    # 'Hex(3)HexNAc(3)',
                    # 'dHex(1)Hex(1)HexNAc(4)',
                    # 'Hex(2)HexNAc(4)',
                    # 'Hex(1)HexNAc(2)NeuAc(2)',
                    # 'dHex(2)Hex(1)HexNAc(2)NeuAc(1)',
                    # 'dHex(1)Hex(2)HexNAc(2)NeuAc(1)',
                    # 'dHex(1)Hex(1)HexNAc(3)NeuAc(1)',
                    # 'Hex(2)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(2)HexNAc(3)',
                    # 'dHex(1)Hex(3)HexNAc(3)',
                    # 'dHex(2)Hex(1)HexNAc(4)',
                    # 'dHex(1)Hex(2)HexNAc(4)',
                    # 'dHex(1)Hex(1)HexNAc(2)NeuAc(2)',
                    'Hex(3)HexNAc(4)',
                    # 'Hex(2)HexNAc(2)NeuAc(2)',
                    # 'dHex(2)Hex(2)HexNAc(2)NeuAc(1)',
                    # 'Hex(2)HexNAc(5)',
                    # 'dHex(2)Hex(1)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(2)HexNAc(3)NeuAc(1)',
                    # 'dHex(3)Hex(2)HexNAc(3)',
                    # 'Hex(3)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(3)HexNAc(3)',
                    # 'Hex(2)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(2)HexNAc(4)',
                    # 'dHex(2)Hex(1)HexNAc(2)NeuAc(2)',
                    # 'dHex(1)Hex(3)HexNAc(4)',
                    # 'dHex(1)Hex(2)HexNAc(2)NeuAc(2)',
                    # 'Hex(4)HexNAc(4)',
                    # 'dHex(1)Hex(2)HexNAc(5)',
                    # 'Hex(3)HexNAc(5)',
                    # 'Hex(2)HexNAc(3)NeuAc(2)',
                    # 'dHex(2)Hex(2)HexNAc(3)NeuAc(1)',
                    # 'dHex(4)Hex(2)HexNAc(3)',
                    # 'dHex(1)Hex(3)HexNAc(3)NeuAc(1)',
                    # 'dHex(3)Hex(3)HexNAc(3)',
                    # 'Hex(2)HexNAc(6)',
                    # 'dHex(1)Hex(2)HexNAc(4)NeuAc(1)',
                    # 'dHex(3)Hex(2)HexNAc(4)',
                    # 'Hex(3)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(3)HexNAc(4)',
                    # 'Hex(2)HexNAc(2)NeuAc(3)',
                    # 'dHex(2)Hex(2)HexNAc(2)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(4)',
                    # 'Hex(2)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(2)HexNAc(5)',
                    # 'dHex(1)Hex(3)HexNAc(5)',
                    # 'dHex(1)Hex(2)HexNAc(3)NeuAc(2)',
                    # 'dHex(3)Hex(2)HexNAc(3)NeuAc(1)',
                    # 'Hex(4)HexNAc(5)',
                    # 'Hex(3)HexNAc(3)NeuAc(2)',
                    # 'dHex(2)Hex(3)HexNAc(3)NeuAc(1)',
                    # 'dHex(4)Hex(3)HexNAc(3)',
                    # 'dHex(1)Hex(2)HexNAc(6)',
                    # 'Hex(3)HexNAc(6)',
                    # 'Hex(2)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(2)HexNAc(4)NeuAc(1)',
                    # 'dHex(4)Hex(2)HexNAc(4)',
                    # 'dHex(1)Hex(3)HexNAc(4)NeuAc(1)',
                    # 'dHex(3)Hex(3)HexNAc(4)',
                    # 'dHex(1)Hex(2)HexNAc(2)NeuAc(3)',
                    # 'Hex(4)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(4)HexNAc(4)',
                    # 'dHex(1)Hex(2)HexNAc(5)NeuAc(1)',
                    # 'dHex(3)Hex(2)HexNAc(5)',
                    # 'Hex(3)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(3)HexNAc(5)',
                    # 'dHex(2)Hex(2)HexNAc(3)NeuAc(2)',
                    # 'dHex(4)Hex(2)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(4)HexNAc(5)',
                    # 'dHex(1)Hex(3)HexNAc(3)NeuAc(2)',
                    # 'dHex(3)Hex(3)HexNAc(3)NeuAc(1)',
                    # 'Hex(5)HexNAc(5)',
                    # 'dHex(2)Hex(2)HexNAc(6)',
                    # 'dHex(1)Hex(3)HexNAc(6)',
                    # 'dHex(1)Hex(2)HexNAc(4)NeuAc(2)',
                    # 'dHex(3)Hex(2)HexNAc(4)NeuAc(1)',
                    # 'Hex(4)HexNAc(6)',
                    # 'Hex(3)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(3)HexNAc(4)NeuAc(1)',
                    # 'dHex(4)Hex(3)HexNAc(4)',
                    # 'dHex(2)Hex(2)HexNAc(2)NeuAc(3)',
                    # 'dHex(1)Hex(4)HexNAc(4)NeuAc(1)',
                    # 'dHex(3)Hex(4)HexNAc(4)',
                    # 'Hex(3)HexNAc(7)',
                    # 'dHex(2)Hex(2)HexNAc(5)NeuAc(1)',
                    # 'dHex(4)Hex(2)HexNAc(5)',
                    # 'dHex(1)Hex(3)HexNAc(5)NeuAc(1)',
                    # 'dHex(3)Hex(3)HexNAc(5)',
                    # 'dHex(3)Hex(2)HexNAc(3)NeuAc(2)',
                    # 'Hex(4)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(4)HexNAc(5)',
                    # 'Hex(3)HexNAc(3)NeuAc(3)',
                    # 'dHex(2)Hex(3)HexNAc(3)NeuAc(2)',
                    # 'dHex(4)Hex(3)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(5)HexNAc(5)',
                    # 'dHex(3)Hex(2)HexNAc(6)',
                    # 'Hex(3)HexNAc(6)NeuAc(1)',
                    # 'dHex(2)Hex(3)HexNAc(6)',
                    # 'dHex(2)Hex(2)HexNAc(4)NeuAc(2)',
                    # 'dHex(4)Hex(2)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(4)HexNAc(6)',
                    # 'dHex(1)Hex(3)HexNAc(4)NeuAc(2)',
                    # 'dHex(3)Hex(3)HexNAc(4)NeuAc(1)',
                    # 'Hex(5)HexNAc(6)',
                    # 'Hex(4)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(4)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(3)HexNAc(7)',
                    # 'dHex(3)Hex(2)HexNAc(5)NeuAc(1)',
                    # 'Hex(4)HexNAc(7)',
                    # 'Hex(3)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(3)HexNAc(5)NeuAc(1)',
                    # 'dHex(4)Hex(2)HexNAc(3)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(5)NeuAc(1)',
                    # 'Hex(3)HexNAc(8)',
                    # 'dHex(1)Hex(3)HexNAc(3)NeuAc(3)',
                    # 'dHex(3)Hex(3)HexNAc(3)NeuAc(2)',
                    # 'Hex(5)HexNAc(5)NeuAc(1)',
                    # 'dHex(1)Hex(3)HexNAc(6)NeuAc(1)',
                    # 'dHex(3)Hex(2)HexNAc(4)NeuAc(2)',
                    # 'Hex(4)HexNAc(6)NeuAc(1)',
                    # 'Hex(3)HexNAc(4)NeuAc(3)',
                    # 'dHex(2)Hex(3)HexNAc(4)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(4)NeuAc(2)',
                    # 'Hex(3)HexNAc(7)NeuAc(1)',
                    # 'dHex(1)Hex(3)HexNAc(5)NeuAc(2)',
                    # 'Hex(4)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(3)HexNAc(3)NeuAc(3)',
                    # 'Hex(3)HexNAc(6)NeuAc(2)',
                    # 'dHex(1)Hex(3)HexNAc(4)NeuAc(3)',
                    # 'Hex(4)HexNAc(4)NeuAc(3)',
                    # 'dHex(2)Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(3)Hex(5)HexNAc(8)',
                    # 'dHex(2)Hex(6)HexNAc(8)NeuAc(1)',
                    # 'Hex(5)HexNAc(6)NeuAc(1)',
                    # 'dHex(2)Hex(8)HexNAc(5)',
                    # 'dHex(1)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(8)',
                    # 'dHex(3)Hex(7)HexNAc(6)NeuAc(2)',
                    # 'dHex(3)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(2)Hex(6)HexNAc(5)NeuAc(2)',
                    # 'dHex(1)Hex(7)HexNAc(7)NeuAc(2)',
                    # 'dHex(3)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(3)Hex(7)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(9)HexNAc(5)NeuAc(2)',
                    # 'Hex(6)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(5)HexNAc(7)NeuAc(2)',
                    # 'dHex(2)Hex(5)HexNAc(4)NeuAc(1)',
                    # 'Hex(7)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(2)Hex(5)HexNAc(6)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'Hex(8)HexNAc(8)NeuAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(5)NeuAc(3)',
                    # 'dHex(1)Hex(8)HexNAc(5)',
                    # 'dHex(2)Hex(6)HexNAc(7)',
                    # 'dHex(5)Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(4)Hex(7)HexNAc(6)',
                    # 'dHex(2)Hex(7)HexNAc(6)NeuAc(4)',
                    # 'dHex(3)Hex(6)HexNAc(5)NeuAc(3)',
                    # 'Hex(6)HexNAc(7)NeuAc(2)',
                    # 'Hex(8)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(5)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(8)',
                    # 'dHex(2)Hex(7)HexNAc(4)',
                    # 'dHex(1)Hex(5)HexNAc(8)NeuAc(1)',
                    # 'dHex(5)Hex(7)HexNAc(7)NeuAc(3)',
                    # 'Hex(7)HexNAc(7)',
                    # 'Hex(4)HexNAc(8)NeuAc(1)',
                    # 'dHex(4)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(1)Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(1)Hex(6)HexNAc(4)',
                    # 'dHex(1)Hex(6)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(6)NeuAc(2)',
                    # 'Hex(7)HexNAc(8)',
                    # 'dHex(2)Hex(6)HexNAc(7)NeuAc(1)',
                    # 'dHex(1)Hex(4)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(5)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'dHex(5)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'Hex(8)HexNAc(7)',
                    # 'dHex(1)Hex(4)HexNAc(6)NeuAc(1)',
                    # 'Hex(6)HexNAc(4)',
                    # 'dHex(1)Hex(6)HexNAc(3)',
                    # 'dHex(4)Hex(6)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(4)NeuAc(2)',
                    # 'dHex(1)Hex(7)HexNAc(4)NeuAc(1)',
                    # 'dHex(3)Hex(7)HexNAc(6)',
                    # 'Hex(7)HexNAc(6)NeuAc(4)',
                    # 'dHex(1)Hex(8)HexNAc(4)NeuAc(2)',
                    # 'Hex(5)HexNAc(4)',
                    # 'dHex(5)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'dHex(6)Hex(8)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(5)',
                    # 'dHex(6)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'Hex(6)HexNAc(5)NeuAc(3)',
                    # 'dHex(2)Hex(8)HexNAc(4)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(8)NeuAc(2)',
                    # 'Hex(8)HexNAc(7)NeuAc(4)',
                    # 'Hex(8)HexNAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(7)NeuAc(1)',
                    # 'dHex(4)Hex(6)HexNAc(5)',
                    # 'Hex(7)HexNAc(7)NeuAc(4)',
                    # 'dHex(2)Hex(7)HexNAc(8)NeuAc(1)',
                    # 'dHex(4)Hex(6)HexNAc(6)NeuAc(1)',
                    # 'dHex(2)Hex(9)HexNAc(4)NeuAc(1)',
                    # 'dHex(4)Hex(6)HexNAc(5)NeuAc(1)',
                    # 'Hex(6)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(5)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(4)HexNAc(6)',
                    # 'Hex(9)HexNAc(2)',
                    # 'dHex(2)Hex(6)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(5)HexNAc(5)',
                    # 'Hex(5)HexNAc(4)NeuAc(2)',
                    # 'dHex(3)Hex(5)HexNAc(6)',
                    # 'dHex(1)Hex(7)HexNAc(5)NeuAc(1)',
                    # 'dHex(5)Hex(7)HexNAc(8)',
                    # 'dHex(4)Hex(6)HexNAc(7)NeuAc(2)',
                    # 'dHex(2)Hex(9)HexNAc(5)',
                    # 'dHex(1)Hex(7)HexNAc(4)',
                    # 'dHex(3)Hex(5)HexNAc(8)NeuAc(2)',
                    # 'dHex(4)Hex(8)HexNAc(8)NeuAc(2)',
                    # 'dHex(5)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(3)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'Hex(5)HexNAc(3)NeuAc(1)',
                    # 'Hex(4)HexNAc(3)NeuAc(1)',
                    # 'dHex(1)Hex(5)HexNAc(4)',
                    # 'Hex(8)HexNAc(4)',
                    # 'dHex(3)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(6)NeuAc(3)',
                    # 'dHex(3)Hex(6)HexNAc(7)NeuAc(3)',
                    # 'Hex(10)HexNAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(7)NeuAc(2)',
                    # 'dHex(4)Hex(6)HexNAc(8)',
                    # 'Hex(6)HexNAc(7)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'dHex(1)Hex(5)HexNAc(7)NeuAc(2)',
                    # 'Hex(7)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(3)',
                    # 'Hex(8)HexNAc(8)NeuAc(3)',
                    # 'dHex(1)Hex(6)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(2)Hex(6)HexNAc(6)',
                    # 'dHex(4)Hex(7)HexNAc(7)',
                    # 'dHex(3)Hex(6)HexNAc(5)NeuAc(2)',
                    # 'Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(4)Hex(7)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(6)NeuAc(1)',
                    'Hex(9)HexNAc(5)',
                    'Hex(7)HexNAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'dHex(1)Hex(7)HexNAc(6)NeuAc(4)',
                    # 'dHex(1)Hex(5)HexNAc(4)NeuAc(2)',
                    # 'dHex(4)Hex(7)HexNAc(8)NeuAc(4)',
                    # 'dHex(4)Hex(8)HexNAc(7)',
                    # 'dHex(1)Hex(6)HexNAc(7)NeuAc(1)',
                    # 'dHex(4)Hex(7)HexNAc(6)NeuAc(4)',
                    # 'dHex(1)Hex(6)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(5)Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(5)Hex(8)HexNAc(8)NeuAc(2)',
                    'Hex(6)HexNAc(2)',
                    # 'dHex(2)Hex(5)HexNAc(6)',
                    # 'Hex(9)HexNAc(4)NeuAc(2)',
                    # 'Hex(6)HexNAc(5)',
                    # 'dHex(3)Hex(8)HexNAc(8)NeuAc(2)',
                    # 'Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(2)Hex(6)HexNAc(7)NeuAc(2)',
                    # 'dHex(1)Hex(3)HexNAc(8)',
                    # 'dHex(2)Hex(8)HexNAc(4)',
                    # 'dHex(5)Hex(7)HexNAc(8)NeuAc(4)',
                    # 'dHex(3)Hex(8)HexNAc(8)',
                    # 'dHex(3)Hex(5)HexNAc(5)NeuAc(1)',
                    # 'dHex(3)Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(3)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(2)Hex(6)HexNAc(5)NeuAc(3)',
                    # 'dHex(1)Hex(7)HexNAc(7)NeuAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(7)',
                    # 'dHex(6)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'dHex(3)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(1)Hex(7)HexNAc(8)NeuAc(1)',
                    # 'dHex(6)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'dHex(1)Hex(7)HexNAc(7)NeuAc(4)',
                    # 'dHex(2)Hex(5)HexNAc(7)NeuAc(1)',
                    # 'Hex(5)HexNAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(6)NeuAc(2)',
                    # 'dHex(2)Hex(5)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(4)NeuAc(1)',
                    # 'Hex(6)HexNAc(4)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(7)',
                    # 'dHex(4)Hex(7)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(7)',
                    # 'dHex(2)Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(2)Hex(9)HexNAc(4)NeuAc(2)',
                    # 'dHex(4)Hex(6)HexNAc(5)NeuAc(2)',
                    # 'dHex(1)Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(2)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'dHex(2)Hex(7)HexNAc(5)',
                    # 'dHex(1)Hex(8)HexNAc(3)NeuAc(1)',
                    # 'dHex(5)Hex(7)HexNAc(7)NeuAc(4)',
                    # 'Hex(6)HexNAc(8)',
                    # 'Hex(7)HexNAc(6)',
                    # 'Hex(5)HexNAc(7)NeuAc(1)',
                    # 'dHex(4)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'dHex(3)Hex(5)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(7)HexNAc(7)NeuAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(4)NeuAc(1)',
                    # 'dHex(3)Hex(5)HexNAc(5)',
                    # 'dHex(2)Hex(4)HexNAc(7)NeuAc(1)',
                    # 'Hex(6)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(7)HexNAc(5)NeuAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(8)',
                    # 'dHex(1)Hex(7)HexNAc(7)',
                    # 'dHex(3)Hex(5)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'dHex(4)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(8)NeuAc(3)',
                    # 'Hex(6)HexNAc(6)',
                    # 'dHex(3)Hex(5)HexNAc(5)NeuAc(2)',
                    # 'dHex(3)Hex(7)HexNAc(8)NeuAc(4)',
                    # 'dHex(1)Hex(6)HexNAc(8)NeuAc(1)',
                    # 'dHex(1)Hex(5)HexNAc(3)',
                    # 'dHex(1)Hex(9)HexNAc(5)',
                    # 'dHex(1)Hex(7)HexNAc(8)NeuAc(4)',
                    # 'Hex(8)HexNAc(5)',
                    # 'dHex(3)Hex(6)HexNAc(7)NeuAc(2)',
                    # 'dHex(6)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(7)',
                    # 'dHex(2)Hex(7)HexNAc(5)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(3)',
                    # 'dHex(6)Hex(8)HexNAc(7)',
                    # 'Hex(5)HexNAc(7)',
                    # 'dHex(2)Hex(9)HexNAc(5)NeuAc(1)',
                    # 'dHex(5)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(6)NeuAc(2)',
                    # 'Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(2)Hex(8)HexNAc(8)',
                    # 'dHex(5)Hex(7)HexNAc(6)NeuAc(4)',
                    # 'dHex(6)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(2)Hex(6)HexNAc(5)',
                    # 'dHex(4)Hex(7)HexNAc(8)',
                    # 'dHex(3)Hex(6)HexNAc(8)NeuAc(3)',
                    # 'dHex(2)Hex(5)HexNAc(8)NeuAc(1)',
                    # 'Hex(6)HexNAc(5)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(5)NeuAc(1)',
                    # 'dHex(1)Hex(6)HexNAc(6)NeuAc(1)',
                    # 'dHex(1)Hex(9)HexNAc(4)NeuAc(2)',
                    # 'Hex(9)HexNAc(4)',
                    # 'dHex(5)Hex(7)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(8)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(8)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(6)NeuAc(1)',
                    # 'dHex(4)Hex(6)HexNAc(8)NeuAc(3)',
                    'Hex(4)HexNAc(2)',
                    # 'dHex(5)Hex(7)HexNAc(6)NeuAc(2)',
                    # 'dHex(3)Hex(5)HexNAc(6)NeuAc(2)',
                    # 'dHex(3)Hex(5)HexNAc(7)NeuAc(1)',
                    # 'Hex(9)HexNAc(5)NeuAc(2)',
                    # 'dHex(4)Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(1)Hex(6)HexNAc(4)NeuAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(6)NeuAc(3)',
                    # 'Hex(8)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(8)',
                    # 'dHex(1)Hex(6)HexNAc(5)',
                    # 'dHex(3)Hex(7)HexNAc(8)',
                    # 'dHex(4)Hex(6)HexNAc(7)NeuAc(3)',
                    # 'dHex(5)Hex(8)HexNAc(8)',
                    # 'Hex(7)HexNAc(7)NeuAc(2)',
                    'Hex(5)HexNAc(2)',
                    # 'dHex(3)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'dHex(1)Hex(7)HexNAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(6)',
                    # 'dHex(3)Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(1)Hex(7)HexNAc(8)',
                    # 'dHex(1)Hex(6)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(4)HexNAc(8)NeuAc(1)',
                    # 'Hex(6)HexNAc(5)NeuAc(1)',
                    # 'dHex(3)Hex(6)HexNAc(6)',
                    # 'dHex(1)Hex(5)HexNAc(6)NeuAc(1)',
                    # 'Hex(5)HexNAc(4)NeuAc(1)',
                    # 'dHex(4)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(1)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'Hex(8)HexNAc(7)NeuAc(3)',
                    # 'Hex(4)HexNAc(7)NeuAc(1)',
                    # 'Hex(8)HexNAc(8)',
                    # 'dHex(5)Hex(7)HexNAc(7)',
                    # 'dHex(4)Hex(6)HexNAc(7)',
                    # 'dHex(1)Hex(4)HexNAc(7)NeuAc(1)',
                    # 'dHex(4)Hex(8)HexNAc(8)',
                    # 'dHex(1)Hex(6)HexNAc(5)NeuAc(1)',
                    # 'dHex(3)Hex(6)HexNAc(7)',
                    # 'dHex(5)Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(4)Hex(6)HexNAc(6)NeuAc(3)',
                    # 'dHex(3)Hex(8)HexNAc(7)',
                    # 'dHex(2)Hex(4)HexNAc(8)',
                    # 'dHex(2)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(7)HexNAc(6)',
                    # 'Hex(5)HexNAc(7)NeuAc(2)',
                    # 'dHex(4)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'dHex(3)Hex(5)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(7)NeuAc(2)',
                    # 'dHex(4)Hex(7)HexNAc(6)NeuAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(6)',
                    # 'dHex(3)Hex(5)HexNAc(4)',
                    # 'dHex(5)Hex(7)HexNAc(6)',
                    # 'dHex(4)Hex(7)HexNAc(7)NeuAc(4)',
                    # 'Hex(6)HexNAc(8)NeuAc(2)',
                    # 'Hex(7)HexNAc(5)NeuAc(1)',
                    # 'dHex(1)Hex(9)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(8)HexNAc(7)NeuAc(4)',
                    # 'dHex(5)Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(5)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'Hex(9)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(5)HexNAc(7)',
                    # 'Hex(6)HexNAc(3)',
                    # 'Hex(12)HexNAc(2)',
                    # 'dHex(3)Hex(5)HexNAc(7)NeuAc(2)',
                    # 'dHex(3)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'Hex(8)HexNAc(4)NeuAc(1)',
                    # 'Hex(7)HexNAc(6)NeuAc(2)',
                    # 'dHex(2)Hex(6)HexNAc(7)NeuAc(3)',
                    # 'dHex(3)Hex(7)HexNAc(6)NeuAc(4)',
                    # 'Hex(6)HexNAc(6)NeuAc(3)',
                    # 'dHex(5)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'dHex(3)Hex(6)HexNAc(6)NeuAc(3)',
                    # 'dHex(6)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(2)Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(3)Hex(6)HexNAc(8)',
                    # 'dHex(2)Hex(4)HexNAc(5)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(6)NeuAc(2)',
                    # 'Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(1)Hex(7)HexNAc(7)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(4)',
                    # 'dHex(1)Hex(8)HexNAc(4)',
                    # 'Hex(4)HexNAc(8)',
                    # 'dHex(2)Hex(5)HexNAc(8)NeuAc(2)',
                    # 'Hex(7)HexNAc(8)NeuAc(1)',
                    # 'Hex(6)HexNAc(7)NeuAc(3)',
                    # 'dHex(4)Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(3)Hex(5)HexNAc(6)NeuAc(1)',
                    # 'dHex(1)Hex(4)HexNAc(3)NeuAc(1)',
                    # 'dHex(4)Hex(7)HexNAc(7)NeuAc(3)',
                    # 'dHex(2)Hex(7)HexNAc(8)NeuAc(4)',
                    # 'Hex(7)HexNAc(4)NeuAc(2)',
                    # 'dHex(1)Hex(9)HexNAc(4)NeuAc(1)',
                    # 'Hex(11)HexNAc(2)',
                    # 'dHex(3)Hex(7)HexNAc(7)NeuAc(4)',
                    # 'dHex(4)Hex(6)HexNAc(5)NeuAc(3)',
                    # 'Hex(8)HexNAc(5)NeuAc(2)',
                    # 'dHex(6)Hex(8)HexNAc(8)',
                    # 'dHex(2)Hex(8)HexNAc(8)NeuAc(1)',
                    # 'Hex(7)HexNAc(5)',
                    # 'dHex(1)Hex(5)HexNAc(5)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(5)HexNAc(8)',
                    # 'Hex(5)HexNAc(8)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(7)NeuAc(1)',
                    # 'Hex(8)HexNAc(4)NeuAc(2)',
                    # 'Hex(5)HexNAc(8)',
                    # 'dHex(1)Hex(7)HexNAc(4)NeuAc(2)',
                    # 'dHex(3)Hex(7)HexNAc(7)',
                    # 'dHex(1)Hex(8)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(6)HexNAc(8)NeuAc(2)',
                    # 'dHex(1)Hex(4)HexNAc(8)',
                    # 'dHex(1)Hex(7)HexNAc(6)',
                    # 'Hex(6)HexNAc(7)',
                    # 'dHex(3)Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(3)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'dHex(1)Hex(9)HexNAc(4)',
                    # 'dHex(1)Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(3)Hex(6)HexNAc(7)NeuAc(1)',
                    # 'dHex(1)Hex(7)HexNAc(3)NeuAc(1)',
                    # 'dHex(2)Hex(7)HexNAc(5)NeuAc(1)',
                    # 'dHex(1)Hex(8)HexNAc(7)NeuAc(2)',
                    # 'Hex(8)HexNAc(7)NeuAc(2)',
                    # 'dHex(2)Hex(5)HexNAc(6)NeuAc(1)',
                    # 'dHex(3)Hex(7)HexNAc(7)NeuAc(3)',
                    # 'dHex(4)Hex(6)HexNAc(6)',
                    # 'dHex(4)Hex(6)HexNAc(6)NeuAc(2)',
                    # 'dHex(1)Hex(8)HexNAc(8)',
                    # 'dHex(2)Hex(5)HexNAc(5)NeuAc(2)',
                    # 'dHex(2)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(6)Hex(8)HexNAc(7)NeuAc(3)',
                    # 'dHex(2)Hex(4)HexNAc(7)',
                    # 'Hex(7)HexNAc(7)NeuAc(1)',
                    # 'Hex(6)HexNAc(6)NeuAc(1)',
                    # 'Hex(4)HexNAc(3)',
                    # 'dHex(5)Hex(7)HexNAc(7)NeuAc(2)',
                    # 'dHex(5)Hex(8)HexNAc(7)',
                    # 'Hex(5)HexNAc(5)NeuAc(2)',
                    # 'dHex(4)Hex(8)HexNAc(7)NeuAc(1)',
                    # 'dHex(3)Hex(7)HexNAc(7)NeuAc(1)',
                    # 'dHex(4)Hex(6)HexNAc(8)NeuAc(2)',
                    # 'dHex(6)Hex(8)HexNAc(8)NeuAc(5)',
                    # 'dHex(1)Hex(6)HexNAc(6)NeuAc(2)',
                    # 'dHex(1)Hex(9)HexNAc(5)NeuAc(2)',
                    # 'Hex(7)HexNAc(6)NeuAc(1)',
                    # 'dHex(1)Hex(7)HexNAc(5)',
                    # 'dHex(2)Hex(9)HexNAc(4)',
                    # 'dHex(4)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'dHex(5)Hex(7)HexNAc(8)NeuAc(1)',
                    # 'dHex(5)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'dHex(2)Hex(5)HexNAc(4)',
                    # 'dHex(3)Hex(7)HexNAc(8)NeuAc(2)',
                    # 'dHex(2)Hex(6)HexNAc(4)NeuAc(2)',
                    # 'dHex(2)Hex(7)HexNAc(4)NeuAc(1)',
                    # 'dHex(1)Hex(6)HexNAc(7)NeuAc(3)',
                    # 'Hex(7)HexNAc(7)NeuAc(3)',
                    # 'dHex(1)Hex(8)HexNAc(4)NeuAc(1)',
                    # 'dHex(2)Hex(6)HexNAc(5)NeuAc(1)',
                    # 'Hex(5)HexNAc(6)NeuAc(2)',
                    # 'dHex(2)Hex(4)HexNAc(6)NeuAc(1)',
                    # 'dHex(6)Hex(8)HexNAc(8)NeuAc(3)',
                    # 'dHex(2)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(1)Hex(6)HexNAc(8)NeuAc(3)',
                    # 'Hex(8)HexNAc(8)NeuAc(1)',
                    # 'Hex(7)HexNAc(8)NeuAc(4)',
                    # 'dHex(3)Hex(6)HexNAc(8)NeuAc(1)',
                    # 'Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(4)Hex(8)HexNAc(8)NeuAc(4)',
                    # 'Hex(8)HexNAc(2)',
                    # 'Hex(9)HexNAc(4)NeuAc(1)',
                    # 'Hex(6)HexNAc(6)NeuAc(2)',
                    # 'dHex(4)Hex(7)HexNAc(7)NeuAc(2)',
                    # 'dHex(1)Hex(6)HexNAc(7)',
                    # 'Hex(3)HexNAc(2)',
                    # 'dHex(1)Hex(7)HexNAc(6)NeuAc(2)',
                    # 'Hex(7)HexNAc(3)',
                    # 'Hex(8)HexNAc(5)NeuAc(1)',
                    # 'dHex(5)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'Hex(7)HexNAc(4)',
                    # 'dHex(3)Hex(7)HexNAc(7)NeuAc(2)',
                    # 'dHex(1)Hex(5)HexNAc(5)NeuAc(2)',
                    # 'dHex(4)Hex(6)HexNAc(8)NeuAc(1)',
                    # 'dHex(4)Hex(7)HexNAc(8)NeuAc(3)',
                    # 'dHex(2)Hex(7)HexNAc(7)',
                    # 'dHex(4)Hex(8)HexNAc(7)NeuAc(5)',
                    # 'dHex(1)Hex(8)HexNAc(5)NeuAc(1)',
                    # 'dHex(4)Hex(7)HexNAc(6)NeuAc(3)',
                    # 'dHex(3)Hex(5)HexNAc(7)',
                    # 'dHex(2)Hex(7)HexNAc(7)NeuAc(4)',
                    'Hex(7)HexNAc(5)NeuAc(2)',
                    # 'Hex(6)HexNAc(8)NeuAc(3)',
                    # 'dHex(1)Hex(5)HexNAc(8)NeuAc(2)',
                    # 'Hex(5)HexNAc(8)NeuAc(2)',
                ],
                'unimods': [],
            },
            'modifications_y_ion_offsets': {
                'chemical_formulas': [],
                'masses': [
                    0,
                    # 203.07937,
                    # 406.15874,
                    # 568.21156,
                    # 730.26438,
                    # 892.3172,
                    # 349.137279
                ],
                'glycans': [
                    'HexNAc(1)',
                    'HexNAc(2)',
                    'HexNAc(2)Hex(1)',
                    'HexNAc(2)Hex(2)',
                    'HexNAc(2)Hex(3)',
                    'HexNAc(1)dHex(1)',
                ],
                'unimods': [],
            },
            'diagnostic_fragments': {
                'chemical_formulas': [],
                'masses': [
                    # 204.086646,
                    # 186.076086,
                    # 168.065526,
                    # 366.139466,
                    # 144.0656,
                    # 138.055,
                    # 512.197375,
                    # 292.1026925,
                    # 274.0921325,
                    # 657.2349,
                    # 243.026426,
                    # 405.079246,
                    # 485.045576,
                    # 308.09761
                ],
                'glycans': [
                    'HexNAc(1)',
                    'HexNAc(2)',
                    'HexNAc(2)Hex(1)',
                    'HexNAc(1)Hex(1)',
                    'Hex(1)',
                ],
                'unimods': [],
            },
            'msfragger_labile_mode': 'nglycan',
            'score_ion_list': ['b','y','b~','y~','Y']
        }
    )

    unified_search_result = uc.search(
        input_file = ms_file,
        engine = 'msfragger_3_0',
    )
    validated_file = uc.validate(
        input_file=unified_search_result,
        engine='percolator_3_4_0',
        force=False,
    )

    filtered_file = uc.execute_misc_engine(
        input_file = validated_file,
        engine = 'filter_csv',
    )
    print('''
        All done.
    ''')
    return


if __name__ == '__main__':
    main(database=sys.argv[2], ms_file=sys.argv[1])
