"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billingcountandamount import BillingCountAndAmount, BillingCountAndAmountTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class ACHFeesTypedDict(TypedDict):
    r"""A detailed breakdown of ACH fees."""

    standard_credit: BillingCountAndAmountTypedDict
    r"""Fees for standard credit transfers."""
    same_day_credit: BillingCountAndAmountTypedDict
    r"""Fees for same-day credit transfers."""
    debits: BillingCountAndAmountTypedDict
    r"""Fees for debit transfers."""
    return_: BillingCountAndAmountTypedDict
    r"""Fees for authorized returns."""
    unauthorized_return: BillingCountAndAmountTypedDict
    r"""Fees for unauthorized returns."""
    notice_of_change: BillingCountAndAmountTypedDict
    r"""Fees for notices of change."""
    total: BillingCountAndAmountTypedDict
    r"""Total ACH fees."""


class ACHFees(BaseModel):
    r"""A detailed breakdown of ACH fees."""

    standard_credit: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="standardCredit")
    ]
    r"""Fees for standard credit transfers."""

    same_day_credit: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="sameDayCredit")
    ]
    r"""Fees for same-day credit transfers."""

    debits: BillingCountAndAmount
    r"""Fees for debit transfers."""

    return_: Annotated[BillingCountAndAmount, pydantic.Field(alias="return")]
    r"""Fees for authorized returns."""

    unauthorized_return: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="unauthorizedReturn")
    ]
    r"""Fees for unauthorized returns."""

    notice_of_change: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="noticeOfChange")
    ]
    r"""Fees for notices of change."""

    total: BillingCountAndAmount
    r"""Total ACH fees."""
