"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .capabilityid import CapabilityID
from .createaccounttype import CreateAccountType
from .createprofile import CreateProfile, CreateProfileTypedDict
from .customersupport import CustomerSupport, CustomerSupportTypedDict
from .manualtermsofservice import ManualTermsOfService, ManualTermsOfServiceTypedDict
from .mode import Mode
from .settings import Settings, SettingsTypedDict
from .termsofservicetoken import TermsOfServiceToken, TermsOfServiceTokenTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CreateAccountTermsOfServiceTypedDict = TypeAliasType(
    "CreateAccountTermsOfServiceTypedDict",
    Union[TermsOfServiceTokenTypedDict, ManualTermsOfServiceTypedDict],
)


CreateAccountTermsOfService = TypeAliasType(
    "CreateAccountTermsOfService", Union[TermsOfServiceToken, ManualTermsOfService]
)


class CreateAccountTypedDict(TypedDict):
    account_type: CreateAccountType
    profile: CreateProfileTypedDict
    metadata: NotRequired[Dict[str, str]]
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""
    terms_of_service: NotRequired[CreateAccountTermsOfServiceTypedDict]
    foreign_id: NotRequired[str]
    r"""Optional alias from a foreign/external system which can be used to reference this resource."""
    customer_support: NotRequired[CustomerSupportTypedDict]
    r"""User-provided information that can be displayed on credit card transactions for customers to use when
    contacting a customer support team. This data is only allowed on a business account.
    """
    settings: NotRequired[SettingsTypedDict]
    r"""User provided settings to manage an account."""
    capabilities: NotRequired[List[CapabilityID]]
    mode: NotRequired[Mode]
    r"""The operating mode for an account."""


class CreateAccount(BaseModel):
    account_type: Annotated[CreateAccountType, pydantic.Field(alias="accountType")]

    profile: CreateProfile

    metadata: Optional[Dict[str, str]] = None
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""

    terms_of_service: Annotated[
        Optional[CreateAccountTermsOfService], pydantic.Field(alias="termsOfService")
    ] = None

    foreign_id: Annotated[Optional[str], pydantic.Field(alias="foreignID")] = None
    r"""Optional alias from a foreign/external system which can be used to reference this resource."""

    customer_support: Annotated[
        Optional[CustomerSupport], pydantic.Field(alias="customerSupport")
    ] = None
    r"""User-provided information that can be displayed on credit card transactions for customers to use when
    contacting a customer support team. This data is only allowed on a business account.
    """

    settings: Optional[Settings] = None
    r"""User provided settings to manage an account."""

    capabilities: Optional[List[CapabilityID]] = None

    mode: Optional[Mode] = None
    r"""The operating mode for an account."""
