"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .documenttype import DocumentType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DocumentTypedDict(TypedDict):
    document_id: str
    type: DocumentType
    r"""Types of documents that can be uploaded."""
    content_type: str
    r"""The document's MIME type."""
    uploaded_at: datetime
    parse_errors: NotRequired[List[str]]
    r"""Optional array of errors encountered during automated parsing."""


class Document(BaseModel):
    document_id: Annotated[str, pydantic.Field(alias="documentID")]

    type: DocumentType
    r"""Types of documents that can be uploaded."""

    content_type: Annotated[str, pydantic.Field(alias="contentType")]
    r"""The document's MIME type."""

    uploaded_at: Annotated[datetime, pydantic.Field(alias="uploadedAt")]

    parse_errors: Annotated[
        Optional[List[str]], pydantic.Field(alias="parseErrors")
    ] = None
    r"""Optional array of errors encountered during automated parsing."""
