"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .authorizeduser import AuthorizedUser, AuthorizedUserTypedDict
from .cardbrand import CardBrand
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .issuedcardformfactor import IssuedCardFormFactor
from .issuedcardstate import IssuedCardState
from .issuingcontrols import IssuingControls, IssuingControlsTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FullIssuedCardTypedDict(TypedDict):
    r"""The full details of an issued card, including PAN and CVV."""

    issued_card_id: str
    brand: CardBrand
    r"""The card brand."""
    last_four_card_number: str
    expiration: CardExpirationTypedDict
    r"""The expiration date of the card or token."""
    authorized_user: AuthorizedUserTypedDict
    r"""Fields for identifying an authorized individual."""
    funding_wallet_id: str
    r"""Unique identifier for the wallet funding the card."""
    state: IssuedCardState
    r"""The `state` represents the operational status of an issued card. A card can only approve incoming authorizations if it is in an active state.

    - `active`: The card is operational and approves authorizations. Generally becomes active shortly after card creation.
    - `inactive`: The card cannot approve authorizations. This is currently a temporary state assigned post-creation during the activation process.
    - `closed`: The card is permanently deactivated and cannot approve authorizations. A card can be closed by request or when it expires.
    - `pending-verification`: Awaiting additional authorized user verification before the card can be activated.
    """
    form_factor: IssuedCardFormFactor
    r"""Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card."""
    created_on: datetime
    pan: str
    r"""The issued card's Primary Account Number (PAN)"""
    cvv: str
    r"""The issued card's 3- or 4-digit Card Verification Value (CVV)."""
    memo: NotRequired[str]
    r"""Optional descriptor for the card."""
    controls: NotRequired[IssuingControlsTypedDict]


class FullIssuedCard(BaseModel):
    r"""The full details of an issued card, including PAN and CVV."""

    issued_card_id: Annotated[str, pydantic.Field(alias="issuedCardID")]

    brand: CardBrand
    r"""The card brand."""

    last_four_card_number: Annotated[str, pydantic.Field(alias="lastFourCardNumber")]

    expiration: CardExpiration
    r"""The expiration date of the card or token."""

    authorized_user: Annotated[AuthorizedUser, pydantic.Field(alias="authorizedUser")]
    r"""Fields for identifying an authorized individual."""

    funding_wallet_id: Annotated[str, pydantic.Field(alias="fundingWalletID")]
    r"""Unique identifier for the wallet funding the card."""

    state: IssuedCardState
    r"""The `state` represents the operational status of an issued card. A card can only approve incoming authorizations if it is in an active state.

    - `active`: The card is operational and approves authorizations. Generally becomes active shortly after card creation.
    - `inactive`: The card cannot approve authorizations. This is currently a temporary state assigned post-creation during the activation process.
    - `closed`: The card is permanently deactivated and cannot approve authorizations. A card can be closed by request or when it expires.
    - `pending-verification`: Awaiting additional authorized user verification before the card can be activated.
    """

    form_factor: Annotated[IssuedCardFormFactor, pydantic.Field(alias="formFactor")]
    r"""Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    pan: str
    r"""The issued card's Primary Account Number (PAN)"""

    cvv: str
    r"""The issued card's 3- or 4-digit Card Verification Value (CVV)."""

    memo: Optional[str] = None
    r"""Optional descriptor for the card."""

    controls: Optional[IssuingControls] = None
