"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .applebillingcontact import AppleBillingContact, AppleBillingContactTypedDict
from .linkapplepaytoken import LinkApplePayToken, LinkApplePayTokenTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class LinkApplePayTypedDict(TypedDict):
    r"""The JSON structure returned from Apple Pay when authorizing a payment session.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypayment)
    for more information.
    """

    token: LinkApplePayTokenTypedDict
    r"""Contains the user's payment information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken)
    for more information.
    """
    billing_contact: NotRequired[AppleBillingContactTypedDict]
    r"""Billing contact information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact)
    for more information.
    """


class LinkApplePay(BaseModel):
    r"""The JSON structure returned from Apple Pay when authorizing a payment session.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypayment)
    for more information.
    """

    token: LinkApplePayToken
    r"""Contains the user's payment information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken)
    for more information.
    """

    billing_contact: Annotated[
        Optional[AppleBillingContact], pydantic.Field(alias="billingContact")
    ] = None
    r"""Billing contact information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact)
    for more information.
    """
