"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .runtransfer import RunTransfer, RunTransferTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OccurrenceTypedDict(TypedDict):
    r"""Occurrences to either create or modify."""

    canceled: NotRequired[bool]
    r"""If set to true, will cancel the occurrence. If set false will resume the occurrence. If unset leaves the value unchanged."""
    occurrence_id: NotRequired[str]
    r"""If set this defines what occurrence to modify, if invalid will fail the request.
    If null or \"\" it defines to add a new occurrence.
    """
    run_on: NotRequired[datetime]
    r"""Timestamp to run the transfer after. Value must be into the future."""
    run_transfer: NotRequired[RunTransferTypedDict]
    r"""Defines the attributes of a transfer."""


class Occurrence(BaseModel):
    r"""Occurrences to either create or modify."""

    canceled: Optional[bool] = None
    r"""If set to true, will cancel the occurrence. If set false will resume the occurrence. If unset leaves the value unchanged."""

    occurrence_id: Annotated[Optional[str], pydantic.Field(alias="occurrenceID")] = None
    r"""If set this defines what occurrence to modify, if invalid will fail the request.
    If null or \"\" it defines to add a new occurrence.
    """

    run_on: Annotated[Optional[datetime], pydantic.Field(alias="runOn")] = None
    r"""Timestamp to run the transfer after. Value must be into the future."""

    run_transfer: Annotated[
        Optional[RunTransfer], pydantic.Field(alias="runTransfer")
    ] = None
    r"""Defines the attributes of a transfer."""
