"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .runtransfer import RunTransfer, RunTransferTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RecurTypedDict(TypedDict):
    r"""Defines configuration for recurring transfers."""

    recurrence_rule: str
    r"""RRule as defined by RFC 5545 (https://www.rfc-editor.org/rfc/rfc5545#section-3.3.10).
    Generators available online at the following sites - https://freetools.textmagic.com/rrule-generator, https://jkbrzt.github.io/rrule/
    """
    run_transfer: RunTransferTypedDict
    r"""Defines the attributes of a transfer."""
    indefinite: NotRequired[bool]
    r"""True if the RRule set runs indefinitely."""
    start: NotRequired[datetime]


class Recur(BaseModel):
    r"""Defines configuration for recurring transfers."""

    recurrence_rule: Annotated[str, pydantic.Field(alias="recurrenceRule")]
    r"""RRule as defined by RFC 5545 (https://www.rfc-editor.org/rfc/rfc5545#section-3.3.10).
    Generators available online at the following sites - https://freetools.textmagic.com/rrule-generator, https://jkbrzt.github.io/rrule/
    """

    run_transfer: Annotated[RunTransfer, pydantic.Field(alias="runTransfer")]
    r"""Defines the attributes of a transfer."""

    indefinite: Optional[bool] = None
    r"""True if the RRule set runs indefinitely."""

    start: Optional[datetime] = None
