"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .rtpfailurecode import RTPFailureCode
from .rtptransactionstatus import RTPTransactionStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RTPTransactionDetailsTypedDict(TypedDict):
    r"""RTP specific details about the transaction."""

    status: RTPTransactionStatus
    r"""Status of a transaction within the RTP lifecycle."""
    network_response_code: NotRequired[str]
    r"""Response code returned by network on failure."""
    failure_code: NotRequired[RTPFailureCode]
    r"""Status codes for RTP failures."""
    initiated_on: NotRequired[datetime]
    completed_on: NotRequired[datetime]
    failed_on: NotRequired[datetime]
    accepted_without_posting_on: NotRequired[datetime]


class RTPTransactionDetails(BaseModel):
    r"""RTP specific details about the transaction."""

    status: RTPTransactionStatus
    r"""Status of a transaction within the RTP lifecycle."""

    network_response_code: Annotated[
        Optional[str], pydantic.Field(alias="networkResponseCode")
    ] = None
    r"""Response code returned by network on failure."""

    failure_code: Annotated[
        Optional[RTPFailureCode], pydantic.Field(alias="failureCode")
    ] = None
    r"""Status codes for RTP failures."""

    initiated_on: Annotated[Optional[datetime], pydantic.Field(alias="initiatedOn")] = (
        None
    )

    completed_on: Annotated[Optional[datetime], pydantic.Field(alias="completedOn")] = (
        None
    )

    failed_on: Annotated[Optional[datetime], pydantic.Field(alias="failedOn")] = None

    accepted_without_posting_on: Annotated[
        Optional[datetime], pydantic.Field(alias="acceptedWithoutPostingOn")
    ] = None
