"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketcontact import TicketContact, TicketContactTypedDict
from .ticketstatus import TicketStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TicketTypedDict(TypedDict):
    ticket_id: str
    number: int
    title: str
    contact: TicketContactTypedDict
    status: TicketStatus
    created_on: datetime
    updated_on: datetime
    latest_message_on: NotRequired[datetime]
    closed_on: NotRequired[datetime]
    foreign_id: NotRequired[str]


class Ticket(BaseModel):
    ticket_id: Annotated[str, pydantic.Field(alias="ticketID")]

    number: int

    title: str

    contact: TicketContact

    status: TicketStatus

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    latest_message_on: Annotated[
        Optional[datetime], pydantic.Field(alias="latestMessageOn")
    ] = None

    closed_on: Annotated[Optional[datetime], pydantic.Field(alias="closedOn")] = None

    foreign_id: Annotated[Optional[str], pydantic.Field(alias="foreignID")] = None
