"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .businesspresence import BusinessPresence
from .cardvolumedistribution import (
    CardVolumeDistribution,
    CardVolumeDistributionTypedDict,
)
from .collectfunds import CollectFunds, CollectFundsTypedDict
from .fulfillmentdetails import FulfillmentDetails, FulfillmentDetailsTypedDict
from .geographicreach import GeographicReach
from .moneytransfer import MoneyTransfer, MoneyTransferTypedDict
from .pendinglitigation import PendingLitigation
from .sendfunds import SendFunds, SendFundsTypedDict
from .underwritingstatus import UnderwritingStatus
from .volumebycustomertype import VolumeByCustomerType, VolumeByCustomerTypeTypedDict
from .volumesharebycustomertype import (
    VolumeShareByCustomerType,
    VolumeShareByCustomerTypeTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UnderwritingTypedDict(TypedDict):
    r"""Describes underwriting values (in USD) used for card payment acceptance."""

    average_transaction_size: NotRequired[int]
    max_transaction_size: NotRequired[int]
    average_monthly_transaction_volume: NotRequired[int]
    status: NotRequired[UnderwritingStatus]
    volume_by_customer_type: NotRequired[VolumeByCustomerTypeTypedDict]
    card_volume_distribution: NotRequired[CardVolumeDistributionTypedDict]
    fulfillment: NotRequired[FulfillmentDetailsTypedDict]
    geographic_reach: NotRequired[GeographicReach]
    business_presence: NotRequired[BusinessPresence]
    pending_litigation: NotRequired[PendingLitigation]
    volume_share_by_customer_type: NotRequired[VolumeShareByCustomerTypeTypedDict]
    collect_funds: NotRequired[CollectFundsTypedDict]
    money_transfer: NotRequired[MoneyTransferTypedDict]
    send_funds: NotRequired[SendFundsTypedDict]


class Underwriting(BaseModel):
    r"""Describes underwriting values (in USD) used for card payment acceptance."""

    average_transaction_size: Annotated[
        Optional[int], pydantic.Field(alias="averageTransactionSize")
    ] = None

    max_transaction_size: Annotated[
        Optional[int], pydantic.Field(alias="maxTransactionSize")
    ] = None

    average_monthly_transaction_volume: Annotated[
        Optional[int], pydantic.Field(alias="averageMonthlyTransactionVolume")
    ] = None

    status: Annotated[
        Optional[UnderwritingStatus],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None

    volume_by_customer_type: Annotated[
        Optional[VolumeByCustomerType], pydantic.Field(alias="volumeByCustomerType")
    ] = None

    card_volume_distribution: Annotated[
        Optional[CardVolumeDistribution], pydantic.Field(alias="cardVolumeDistribution")
    ] = None

    fulfillment: Optional[FulfillmentDetails] = None

    geographic_reach: Annotated[
        Optional[GeographicReach], pydantic.Field(alias="geographicReach")
    ] = None

    business_presence: Annotated[
        Optional[BusinessPresence], pydantic.Field(alias="businessPresence")
    ] = None

    pending_litigation: Annotated[
        Optional[PendingLitigation], pydantic.Field(alias="pendingLitigation")
    ] = None

    volume_share_by_customer_type: Annotated[
        Optional[VolumeShareByCustomerType],
        pydantic.Field(alias="volumeShareByCustomerType"),
    ] = None

    collect_funds: Annotated[
        Optional[CollectFunds], pydantic.Field(alias="collectFunds")
    ] = None

    money_transfer: Annotated[
        Optional[MoneyTransfer], pydantic.Field(alias="moneyTransfer")
    ] = None

    send_funds: Annotated[Optional[SendFunds], pydantic.Field(alias="sendFunds")] = None
