"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .walletavailablebalance import (
    WalletAvailableBalance,
    WalletAvailableBalanceTypedDict,
)
from .walletstatus import WalletStatus
from .wallettype import WalletType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WalletTypedDict(TypedDict):
    r"""A Moov wallet to store funds for transfers."""

    wallet_id: str
    available_balance: WalletAvailableBalanceTypedDict
    partner_account_id: str
    name: str
    r"""Name of the wallet"""
    status: WalletStatus
    r"""Status of a wallet.
    - `active`: The wallet is available for use and has an enabled payment method.
    - `closed`: The wallet is no longer active and the corresponding payment method has been disabled.
    """
    wallet_type: WalletType
    r"""Type of a wallet.
    - `default`: The primary system-generated wallet automatically created by Moov when an account is granted the wallet capability. This generates a moov-wallet payment method that is available for use immediately. Only one default wallet exists per account.
    - `general`: A user-defined wallet created via the API to segment funds for specific use cases. Users can create multiple general wallets per account to support internal business models or financial reporting needs.
    """
    description: str
    r"""Description of the wallet"""
    created_on: datetime
    metadata: NotRequired[Dict[str, str]]
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""
    closed_on: NotRequired[datetime]


class Wallet(BaseModel):
    r"""A Moov wallet to store funds for transfers."""

    wallet_id: Annotated[str, pydantic.Field(alias="walletID")]

    available_balance: Annotated[
        WalletAvailableBalance, pydantic.Field(alias="availableBalance")
    ]

    partner_account_id: Annotated[str, pydantic.Field(alias="partnerAccountID")]

    name: str
    r"""Name of the wallet"""

    status: WalletStatus
    r"""Status of a wallet.
    - `active`: The wallet is available for use and has an enabled payment method.
    - `closed`: The wallet is no longer active and the corresponding payment method has been disabled.
    """

    wallet_type: Annotated[WalletType, pydantic.Field(alias="walletType")]
    r"""Type of a wallet.
    - `default`: The primary system-generated wallet automatically created by Moov when an account is granted the wallet capability. This generates a moov-wallet payment method that is available for use immediately. Only one default wallet exists per account.
    - `general`: A user-defined wallet created via the API to segment funds for specific use cases. Users can create multiple general wallets per account to support internal business models or financial reporting needs.
    """

    description: str
    r"""Description of the wallet"""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    metadata: Optional[Dict[str, str]] = None
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""

    closed_on: Annotated[Optional[datetime], pydantic.Field(alias="closedOn")] = None
