"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    enrichedaddressresponse as components_enrichedaddressresponse,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetEnrichmentAddressGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetEnrichmentAddressGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetEnrichmentAddressRequestTypedDict(TypedDict):
    search: str
    r"""Partial or complete address to search."""
    max_results: NotRequired[int]
    r"""Maximum number of results to return."""
    include_cities: NotRequired[str]
    r"""Limits results to a list of given cities."""
    include_states: NotRequired[str]
    r"""Limits results to a list of given states."""
    include_zipcodes: NotRequired[str]
    r"""Limits results to a list of given zipcodes."""
    exclude_states: NotRequired[str]
    r"""Exclude list of states from results. No `include` pararmeters may be used with this parameter."""
    prefer_cities: NotRequired[str]
    r"""Display results with the listed cities at the top."""
    prefer_states: NotRequired[str]
    r"""Display results with the listed states at the top."""
    prefer_zipcodes: NotRequired[str]
    r"""Display results with the listed zipcodes at the top."""
    prefer_ratio: NotRequired[int]
    r"""Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results."""
    prefer_geolocation: NotRequired[str]
    r"""If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state
    to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is
    not set to `none`, you may see addresses from areas you do not wish to see.
    """
    selected: NotRequired[str]
    r"""Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences)."""
    source: NotRequired[str]
    r"""Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only)."""


class GetEnrichmentAddressRequest(BaseModel):
    search: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]
    r"""Partial or complete address to search."""

    max_results: Annotated[
        Optional[int],
        pydantic.Field(alias="maxResults"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Maximum number of results to return."""

    include_cities: Annotated[
        Optional[str],
        pydantic.Field(alias="includeCities"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Limits results to a list of given cities."""

    include_states: Annotated[
        Optional[str],
        pydantic.Field(alias="includeStates"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Limits results to a list of given states."""

    include_zipcodes: Annotated[
        Optional[str],
        pydantic.Field(alias="includeZipcodes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Limits results to a list of given zipcodes."""

    exclude_states: Annotated[
        Optional[str],
        pydantic.Field(alias="excludeStates"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Exclude list of states from results. No `include` pararmeters may be used with this parameter."""

    prefer_cities: Annotated[
        Optional[str],
        pydantic.Field(alias="preferCities"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Display results with the listed cities at the top."""

    prefer_states: Annotated[
        Optional[str],
        pydantic.Field(alias="preferStates"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Display results with the listed states at the top."""

    prefer_zipcodes: Annotated[
        Optional[str],
        pydantic.Field(alias="preferZipcodes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Display results with the listed zipcodes at the top."""

    prefer_ratio: Annotated[
        Optional[int],
        pydantic.Field(alias="preferRatio"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Specifies the percentage of address suggestions that should be preferred and will appear at the top of the results."""

    prefer_geolocation: Annotated[
        Optional[str],
        pydantic.Field(alias="preferGeolocation"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""If omitted or set to `city`, it uses the sender's IP address to determine location, then automatically adds the city and state
    to the preferCities value. This parameter takes precedence over other `include` or `exclude` parameters meaning that if it is
    not set to `none`, you may see addresses from areas you do not wish to see.
    """

    selected: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Useful for narrowing results with `addressLine2` suggestions such as `Apt` (denotes an apartment building with multiple residences)."""

    source: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Include results from alternate data sources. Allowed values are `all` (non-postal addresses), or `postal` (postal addresses only)."""


class GetEnrichmentAddressResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: components_enrichedaddressresponse.EnrichedAddressResponseTypedDict


class GetEnrichmentAddressResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: components_enrichedaddressresponse.EnrichedAddressResponse
