"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.models.components import qrcode as components_qrcode
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata, PathParamMetadata
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetPaymentLinkQRCodeGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetPaymentLinkQRCodeGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetPaymentLinkQRCodeRequestTypedDict(TypedDict):
    account_id: str
    payment_link_code: str


class GetPaymentLinkQRCodeRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    payment_link_code: Annotated[
        str,
        pydantic.Field(alias="paymentLinkCode"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]


GetPaymentLinkQRCodeResponseResultTypedDict = TypeAliasType(
    "GetPaymentLinkQRCodeResponseResultTypedDict",
    Union[components_qrcode.QRCodeTypedDict, httpx.Response],
)


GetPaymentLinkQRCodeResponseResult = TypeAliasType(
    "GetPaymentLinkQRCodeResponseResult",
    Union[components_qrcode.QRCode, httpx.Response],
)


class GetPaymentLinkQRCodeResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: GetPaymentLinkQRCodeResponseResultTypedDict


class GetPaymentLinkQRCodeResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: GetPaymentLinkQRCodeResponseResult
