"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    institutionssearchresponse as components_institutionssearchresponse,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SearchInstitutionsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class SearchInstitutionsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class SearchInstitutionsRequestTypedDict(TypedDict):
    name: NotRequired[str]
    r"""Name of the financial institution. Either `name` or `routingNumber` is required."""
    routing_number: NotRequired[str]
    r"""Routing number for a financial institution. Either `routingNumber` or `name` is required."""
    limit: NotRequired[int]
    r"""Maximum results returned by a search."""


class SearchInstitutionsRequest(BaseModel):
    name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Name of the financial institution. Either `name` or `routingNumber` is required."""

    routing_number: Annotated[
        Optional[str],
        pydantic.Field(alias="routingNumber"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Routing number for a financial institution. Either `routingNumber` or `name` is required."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Maximum results returned by a search."""


class SearchInstitutionsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: components_institutionssearchresponse.InstitutionsSearchResponseTypedDict


class SearchInstitutionsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: components_institutionssearchresponse.InstitutionsSearchResponse
