# Generated by Django 4.1.1 on 2022-10-12 10:15

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="CalendarEvent",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                (
                    "title",
                    models.CharField(blank=True, max_length=255, verbose_name="title"),
                ),
                ("start_time", models.DateTimeField(null=True)),
                (
                    "status",
                    models.CharField(blank=True, max_length=255, verbose_name="status"),
                ),
            ],
            options={
                "verbose_name": "calendar event",
                "verbose_name_plural": "calendar events",
            },
        ),
        migrations.CreateModel(
            name="CDT",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                ("name", models.CharField(max_length=255)),
                ("title", models.CharField(blank=True, max_length=255)),
                ("label", models.CharField(blank=True, max_length=255)),
                ("version", models.IntegerField()),
                ("readable", models.BooleanField()),
                ("updatable", models.BooleanField()),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("SINGLE_RECORD", "Single Record"),
                            ("MULTI_RECORD", "Multi Record"),
                        ],
                        max_length=13,
                    ),
                ),
                ("relation", models.CharField(max_length=255)),
                ("fields", models.JSONField()),
                ("contains_phi", models.BooleanField()),
            ],
            options={
                "verbose_name": "CDT",
                "verbose_name_plural": "CDTs",
            },
        ),
        migrations.CreateModel(
            name="CDTRecord",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                ("version", models.IntegerField(null=True)),
                ("body", models.JSONField(null=True)),
            ],
            options={
                "verbose_name": "CDT record",
                "verbose_name_plural": "CDT records",
            },
        ),
        migrations.CreateModel(
            name="Chat",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                ("message", models.TextField()),
                (
                    "created_at",
                    models.DateTimeField(help_text="When the message was created."),
                ),
            ],
            options={
                "verbose_name": "chat",
                "verbose_name_plural": "chats",
            },
        ),
        migrations.CreateModel(
            name="Configuration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tenant",
                    models.CharField(
                        help_text="Welkin organization name.", max_length=255
                    ),
                ),
                (
                    "instance",
                    models.CharField(
                        help_text="The environment inside a Welkin organization.",
                        max_length=255,
                    ),
                ),
                (
                    "api_client",
                    models.CharField(
                        help_text="Welkin API client name.",
                        max_length=255,
                        verbose_name="API client",
                    ),
                ),
                (
                    "secret_key",
                    models.CharField(
                        help_text="Welkin API client secret key.", max_length=255
                    ),
                ),
            ],
            options={
                "verbose_name": "configuration",
            },
        ),
        migrations.CreateModel(
            name="Patient",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                (
                    "first_name",
                    models.CharField(max_length=255, verbose_name="first name"),
                ),
                (
                    "last_name",
                    models.CharField(max_length=255, verbose_name="last name"),
                ),
            ],
            options={
                "verbose_name": "patient",
                "verbose_name_plural": "patients",
            },
        ),
        migrations.CreateModel(
            name="Provider",
            fields=[
                (
                    "id",
                    models.UUIDField(editable=False, primary_key=True, serialize=False),
                ),
                (
                    "first_name",
                    models.CharField(max_length=255, verbose_name="first name"),
                ),
                (
                    "last_name",
                    models.CharField(max_length=255, verbose_name="last name"),
                ),
            ],
            options={
                "verbose_name": "provider",
                "verbose_name_plural": "providers",
            },
        ),
        migrations.CreateModel(
            name="WebhookMessage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "received_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="When we received the event."
                    ),
                ),
                ("payload", models.JSONField(default=None, null=True)),
            ],
            options={
                "verbose_name": "webhook message",
                "verbose_name_plural": "webhook messages",
            },
        ),
        migrations.AddIndex(
            model_name="webhookmessage",
            index=models.Index(
                fields=["received_at"], name="django_welk_receive_51a88c_idx"
            ),
        ),
        migrations.AddField(
            model_name="chat",
            name="patient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="django_welkin.patient"
            ),
        ),
        migrations.AddField(
            model_name="chat",
            name="provider",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="django_welkin.provider",
            ),
        ),
        migrations.AddField(
            model_name="cdtrecord",
            name="cdt",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="django_welkin.cdt"
            ),
        ),
        migrations.AddField(
            model_name="cdtrecord",
            name="patient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="django_welkin.patient"
            ),
        ),
        migrations.AddField(
            model_name="calendarevent",
            name="patient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="django_welkin.patient"
            ),
        ),
        migrations.AddField(
            model_name="calendarevent",
            name="provider",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="django_welkin.provider"
            ),
        ),
    ]
