# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class AccessLevel(pulumi.CustomResource):
    basic: pulumi.Output[dict]
    description: pulumi.Output[str]
    name: pulumi.Output[str]
    parent: pulumi.Output[str]
    title: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, basic=None, description=None, name=None, parent=None, title=None, __props__=None, __name__=None, __opts__=None):
        """
        An AccessLevel is a label that can be applied to requests to GCP services,
        along with a list of requirements necessary for the label to be applied.
        
        
        To get more information about AccessLevel, see:
        
        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.accessLevels)
        * How-to Guides
            * [Access Policy Quickstart](https://cloud.google.com/access-context-manager/docs/quickstart)
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **basic** object supports the following:
        
          * `combiningFunction` (`pulumi.Input[str]`)
          * `conditions` (`pulumi.Input[list]`)
        
            * `devicePolicy` (`pulumi.Input[dict]`)
        
              * `allowedDeviceManagementLevels` (`pulumi.Input[list]`)
              * `allowedEncryptionStatuses` (`pulumi.Input[list]`)
              * `osConstraints` (`pulumi.Input[list]`)
        
                * `minimumVersion` (`pulumi.Input[str]`)
                * `osType` (`pulumi.Input[str]`)
        
              * `requireAdminApproval` (`pulumi.Input[bool]`)
              * `requireCorpOwned` (`pulumi.Input[bool]`)
              * `requireScreenLock` (`pulumi.Input[bool]`)
        
            * `ipSubnetworks` (`pulumi.Input[list]`)
            * `members` (`pulumi.Input[list]`)
            * `negate` (`pulumi.Input[bool]`)
            * `requiredAccessLevels` (`pulumi.Input[list]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/access_context_manager_access_level.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['basic'] = basic
            __props__['description'] = description
            __props__['name'] = name
            if parent is None:
                raise TypeError("Missing required property 'parent'")
            __props__['parent'] = parent
            if title is None:
                raise TypeError("Missing required property 'title'")
            __props__['title'] = title
        super(AccessLevel, __self__).__init__(
            'gcp:accesscontextmanager/accessLevel:AccessLevel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, basic=None, description=None, name=None, parent=None, title=None):
        """
        Get an existing AccessLevel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **basic** object supports the following:
        
          * `combiningFunction` (`pulumi.Input[str]`)
          * `conditions` (`pulumi.Input[list]`)
        
            * `devicePolicy` (`pulumi.Input[dict]`)
        
              * `allowedDeviceManagementLevels` (`pulumi.Input[list]`)
              * `allowedEncryptionStatuses` (`pulumi.Input[list]`)
              * `osConstraints` (`pulumi.Input[list]`)
        
                * `minimumVersion` (`pulumi.Input[str]`)
                * `osType` (`pulumi.Input[str]`)
        
              * `requireAdminApproval` (`pulumi.Input[bool]`)
              * `requireCorpOwned` (`pulumi.Input[bool]`)
              * `requireScreenLock` (`pulumi.Input[bool]`)
        
            * `ipSubnetworks` (`pulumi.Input[list]`)
            * `members` (`pulumi.Input[list]`)
            * `negate` (`pulumi.Input[bool]`)
            * `requiredAccessLevels` (`pulumi.Input[list]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/access_context_manager_access_level.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["basic"] = basic
        __props__["description"] = description
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["title"] = title
        return AccessLevel(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

