# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Budget(pulumi.CustomResource):
    all_updates_rule: pulumi.Output[dict]
    amount: pulumi.Output[dict]
    billing_account: pulumi.Output[str]
    budget_filter: pulumi.Output[dict]
    display_name: pulumi.Output[str]
    name: pulumi.Output[str]
    threshold_rules: pulumi.Output[list]
    def __init__(__self__, resource_name, opts=None, all_updates_rule=None, amount=None, billing_account=None, budget_filter=None, display_name=None, threshold_rules=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Budget resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **all_updates_rule** object supports the following:
        
          * `pubsubTopic` (`pulumi.Input[str]`)
          * `schemaVersion` (`pulumi.Input[str]`)
        
        The **amount** object supports the following:
        
          * `specifiedAmount` (`pulumi.Input[dict]`)
        
            * `currencyCode` (`pulumi.Input[str]`)
            * `nanos` (`pulumi.Input[float]`)
            * `units` (`pulumi.Input[str]`)
        
        The **budget_filter** object supports the following:
        
          * `creditTypesTreatment` (`pulumi.Input[str]`)
          * `projects` (`pulumi.Input[list]`)
          * `services` (`pulumi.Input[list]`)
        
        The **threshold_rules** object supports the following:
        
          * `spendBasis` (`pulumi.Input[str]`)
          * `thresholdPercent` (`pulumi.Input[float]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/billing_budget.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['all_updates_rule'] = all_updates_rule
            if amount is None:
                raise TypeError("Missing required property 'amount'")
            __props__['amount'] = amount
            if billing_account is None:
                raise TypeError("Missing required property 'billing_account'")
            __props__['billing_account'] = billing_account
            __props__['budget_filter'] = budget_filter
            __props__['display_name'] = display_name
            if threshold_rules is None:
                raise TypeError("Missing required property 'threshold_rules'")
            __props__['threshold_rules'] = threshold_rules
            __props__['name'] = None
        super(Budget, __self__).__init__(
            'gcp:billing/budget:Budget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, all_updates_rule=None, amount=None, billing_account=None, budget_filter=None, display_name=None, name=None, threshold_rules=None):
        """
        Get an existing Budget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **all_updates_rule** object supports the following:
        
          * `pubsubTopic` (`pulumi.Input[str]`)
          * `schemaVersion` (`pulumi.Input[str]`)
        
        The **amount** object supports the following:
        
          * `specifiedAmount` (`pulumi.Input[dict]`)
        
            * `currencyCode` (`pulumi.Input[str]`)
            * `nanos` (`pulumi.Input[float]`)
            * `units` (`pulumi.Input[str]`)
        
        The **budget_filter** object supports the following:
        
          * `creditTypesTreatment` (`pulumi.Input[str]`)
          * `projects` (`pulumi.Input[list]`)
          * `services` (`pulumi.Input[list]`)
        
        The **threshold_rules** object supports the following:
        
          * `spendBasis` (`pulumi.Input[str]`)
          * `thresholdPercent` (`pulumi.Input[float]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/billing_budget.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["all_updates_rule"] = all_updates_rule
        __props__["amount"] = amount
        __props__["billing_account"] = billing_account
        __props__["budget_filter"] = budget_filter
        __props__["display_name"] = display_name
        __props__["name"] = name
        __props__["threshold_rules"] = threshold_rules
        return Budget(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

