# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Image(pulumi.CustomResource):
    archive_size_bytes: pulumi.Output[float]
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    disk_size_gb: pulumi.Output[float]
    family: pulumi.Output[str]
    guest_os_features: pulumi.Output[list]
    label_fingerprint: pulumi.Output[str]
    labels: pulumi.Output[dict]
    licenses: pulumi.Output[list]
    name: pulumi.Output[str]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    raw_disk: pulumi.Output[dict]
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    source_disk: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, disk_size_gb=None, family=None, guest_os_features=None, labels=None, licenses=None, name=None, project=None, raw_disk=None, source_disk=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Image resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **guest_os_features** object supports the following:
        
          * `type` (`pulumi.Input[str]`)
        
        The **raw_disk** object supports the following:
        
          * `containerType` (`pulumi.Input[str]`)
          * `sha1` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_image.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['disk_size_gb'] = disk_size_gb
            __props__['family'] = family
            __props__['guest_os_features'] = guest_os_features
            __props__['labels'] = labels
            __props__['licenses'] = licenses
            __props__['name'] = name
            __props__['project'] = project
            __props__['raw_disk'] = raw_disk
            __props__['source_disk'] = source_disk
            __props__['archive_size_bytes'] = None
            __props__['creation_timestamp'] = None
            __props__['label_fingerprint'] = None
            __props__['self_link'] = None
        super(Image, __self__).__init__(
            'gcp:compute/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, archive_size_bytes=None, creation_timestamp=None, description=None, disk_size_gb=None, family=None, guest_os_features=None, label_fingerprint=None, labels=None, licenses=None, name=None, project=None, raw_disk=None, self_link=None, source_disk=None):
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        
        The **guest_os_features** object supports the following:
        
          * `type` (`pulumi.Input[str]`)
        
        The **raw_disk** object supports the following:
        
          * `containerType` (`pulumi.Input[str]`)
          * `sha1` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_image.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["archive_size_bytes"] = archive_size_bytes
        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["disk_size_gb"] = disk_size_gb
        __props__["family"] = family
        __props__["guest_os_features"] = guest_os_features
        __props__["label_fingerprint"] = label_fingerprint
        __props__["labels"] = labels
        __props__["licenses"] = licenses
        __props__["name"] = name
        __props__["project"] = project
        __props__["raw_disk"] = raw_disk
        __props__["self_link"] = self_link
        __props__["source_disk"] = source_disk
        return Image(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

