# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class RegionHealthCheck(pulumi.CustomResource):
    check_interval_sec: pulumi.Output[float]
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    healthy_threshold: pulumi.Output[float]
    http2_health_check: pulumi.Output[dict]
    http_health_check: pulumi.Output[dict]
    https_health_check: pulumi.Output[dict]
    name: pulumi.Output[str]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    ssl_health_check: pulumi.Output[dict]
    tcp_health_check: pulumi.Output[dict]
    timeout_sec: pulumi.Output[float]
    type: pulumi.Output[str]
    unhealthy_threshold: pulumi.Output[float]
    def __init__(__self__, resource_name, opts=None, check_interval_sec=None, description=None, healthy_threshold=None, http2_health_check=None, http_health_check=None, https_health_check=None, name=None, project=None, region=None, ssl_health_check=None, tcp_health_check=None, timeout_sec=None, unhealthy_threshold=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a RegionHealthCheck resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **http2_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **http_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **https_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **ssl_health_check** object supports the following:
        
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **tcp_health_check** object supports the following:
        
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_region_health_check.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['check_interval_sec'] = check_interval_sec
            __props__['description'] = description
            __props__['healthy_threshold'] = healthy_threshold
            __props__['http2_health_check'] = http2_health_check
            __props__['http_health_check'] = http_health_check
            __props__['https_health_check'] = https_health_check
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
            __props__['ssl_health_check'] = ssl_health_check
            __props__['tcp_health_check'] = tcp_health_check
            __props__['timeout_sec'] = timeout_sec
            __props__['unhealthy_threshold'] = unhealthy_threshold
            __props__['creation_timestamp'] = None
            __props__['self_link'] = None
            __props__['type'] = None
        super(RegionHealthCheck, __self__).__init__(
            'gcp:compute/regionHealthCheck:RegionHealthCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, check_interval_sec=None, creation_timestamp=None, description=None, healthy_threshold=None, http2_health_check=None, http_health_check=None, https_health_check=None, name=None, project=None, region=None, self_link=None, ssl_health_check=None, tcp_health_check=None, timeout_sec=None, type=None, unhealthy_threshold=None):
        """
        Get an existing RegionHealthCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        
        The **http2_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **http_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **https_health_check** object supports the following:
        
          * `host` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request_path` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **ssl_health_check** object supports the following:
        
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)
        
        The **tcp_health_check** object supports the following:
        
          * `port` (`pulumi.Input[float]`)
          * `port_name` (`pulumi.Input[str]`)
          * `portSpecification` (`pulumi.Input[str]`)
          * `proxy_header` (`pulumi.Input[str]`)
          * `request` (`pulumi.Input[str]`)
          * `response` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_region_health_check.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["check_interval_sec"] = check_interval_sec
        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["healthy_threshold"] = healthy_threshold
        __props__["http2_health_check"] = http2_health_check
        __props__["http_health_check"] = http_health_check
        __props__["https_health_check"] = https_health_check
        __props__["name"] = name
        __props__["project"] = project
        __props__["region"] = region
        __props__["self_link"] = self_link
        __props__["ssl_health_check"] = ssl_health_check
        __props__["tcp_health_check"] = tcp_health_check
        __props__["timeout_sec"] = timeout_sec
        __props__["type"] = type
        __props__["unhealthy_threshold"] = unhealthy_threshold
        return RegionHealthCheck(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

