# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Reservation(pulumi.CustomResource):
    commitment: pulumi.Output[str]
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    name: pulumi.Output[str]
    project: pulumi.Output[str]
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    specific_reservation: pulumi.Output[dict]
    specific_reservation_required: pulumi.Output[bool]
    status: pulumi.Output[str]
    zone: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, name=None, project=None, specific_reservation=None, specific_reservation_required=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Reservation resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **specific_reservation** object supports the following:
        
          * `count` (`pulumi.Input[float]`)
          * `inUseCount` (`pulumi.Input[float]`)
          * `instanceProperties` (`pulumi.Input[dict]`)
        
            * `guest_accelerators` (`pulumi.Input[list]`)
        
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `acceleratorType` (`pulumi.Input[str]`)
        
            * `localSsds` (`pulumi.Input[list]`)
        
              * `disk_size_gb` (`pulumi.Input[float]`)
              * `interface` (`pulumi.Input[str]`)
        
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_reservation.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['name'] = name
            __props__['project'] = project
            if specific_reservation is None:
                raise TypeError("Missing required property 'specific_reservation'")
            __props__['specific_reservation'] = specific_reservation
            __props__['specific_reservation_required'] = specific_reservation_required
            if zone is None:
                raise TypeError("Missing required property 'zone'")
            __props__['zone'] = zone
            __props__['commitment'] = None
            __props__['creation_timestamp'] = None
            __props__['self_link'] = None
            __props__['status'] = None
        super(Reservation, __self__).__init__(
            'gcp:compute/reservation:Reservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, commitment=None, creation_timestamp=None, description=None, name=None, project=None, self_link=None, specific_reservation=None, specific_reservation_required=None, status=None, zone=None):
        """
        Get an existing Reservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        
        The **specific_reservation** object supports the following:
        
          * `count` (`pulumi.Input[float]`)
          * `inUseCount` (`pulumi.Input[float]`)
          * `instanceProperties` (`pulumi.Input[dict]`)
        
            * `guest_accelerators` (`pulumi.Input[list]`)
        
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `acceleratorType` (`pulumi.Input[str]`)
        
            * `localSsds` (`pulumi.Input[list]`)
        
              * `disk_size_gb` (`pulumi.Input[float]`)
              * `interface` (`pulumi.Input[str]`)
        
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_reservation.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["commitment"] = commitment
        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["name"] = name
        __props__["project"] = project
        __props__["self_link"] = self_link
        __props__["specific_reservation"] = specific_reservation
        __props__["specific_reservation_required"] = specific_reservation_required
        __props__["status"] = status
        __props__["zone"] = zone
        return Reservation(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

