# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Deployment(pulumi.CustomResource):
    create_policy: pulumi.Output[str]
    delete_policy: pulumi.Output[str]
    deployment_id: pulumi.Output[str]
    description: pulumi.Output[str]
    labels: pulumi.Output[list]
    manifest: pulumi.Output[str]
    name: pulumi.Output[str]
    preview: pulumi.Output[bool]
    project: pulumi.Output[str]
    self_link: pulumi.Output[str]
    target: pulumi.Output[dict]
    def __init__(__self__, resource_name, opts=None, create_policy=None, delete_policy=None, description=None, labels=None, name=None, preview=None, project=None, target=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Deployment resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **labels** object supports the following:
        
          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)
        
        The **target** object supports the following:
        
          * `config` (`pulumi.Input[dict]`)
        
            * `content` (`pulumi.Input[str]`)
        
          * `imports` (`pulumi.Input[list]`)
        
            * `content` (`pulumi.Input[str]`)
            * `name` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/deployment_manager_deployment.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['create_policy'] = create_policy
            __props__['delete_policy'] = delete_policy
            __props__['description'] = description
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['preview'] = preview
            __props__['project'] = project
            if target is None:
                raise TypeError("Missing required property 'target'")
            __props__['target'] = target
            __props__['deployment_id'] = None
            __props__['manifest'] = None
            __props__['self_link'] = None
        super(Deployment, __self__).__init__(
            'gcp:deploymentmanager/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, create_policy=None, delete_policy=None, deployment_id=None, description=None, labels=None, manifest=None, name=None, preview=None, project=None, self_link=None, target=None):
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        
        The **labels** object supports the following:
        
          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)
        
        The **target** object supports the following:
        
          * `config` (`pulumi.Input[dict]`)
        
            * `content` (`pulumi.Input[str]`)
        
          * `imports` (`pulumi.Input[list]`)
        
            * `content` (`pulumi.Input[str]`)
            * `name` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/deployment_manager_deployment.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["create_policy"] = create_policy
        __props__["delete_policy"] = delete_policy
        __props__["deployment_id"] = deployment_id
        __props__["description"] = description
        __props__["labels"] = labels
        __props__["manifest"] = manifest
        __props__["name"] = name
        __props__["preview"] = preview
        __props__["project"] = project
        __props__["self_link"] = self_link
        __props__["target"] = target
        return Deployment(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

