
currency_quote_convention = {
'ADP':'USDADP',
'AED':'USDAED',
'AFN':'USDAFN',
'ALL':'USDALL',
'AMD':'USDAMD',
'ANG':'USDANG',
'AOA':'USDAOA',
'ARS':'USDARS',
'ATS':'USDATS',
'AUD':'AUDUSD',
'AWG':'USDAWG',
'AZN':'USDAZN',
'BAM':'USDBAM',
'BBD':'USDBBD',
'BDT':'USDBDT',
'BEF':'USDBEF',
'BGN':'USDBGN',
'BHD':'USDBHD',
'BIF':'USDBIF',
'BMD':'USDBMD',
'BND':'USDBND',
'BOB':'USDBOB',
'BRL':'USDBRL',
'BSD':'USDBSD',
'BTN':'USDBTN',
'BWP':'BWPUSD',
'BYR':'USDBYR',
'BZD':'USDBZD',
'CAD':'USDCAD',
'CDF':'USDCDF',
'CHF':'USDCHF',
'CLP':'USDCLP',
'CNH':'USDCNH',
'CNY':'USDCNY',
'COP':'USDCOP',
'CRC':'USDCRC',
'CUP':'USDCUP',
'CVE':'USDCVE',
'CZK':'USDCZK',
'DEM':'USDDEM',
'DJF':'USDDJF',
'DKK':'USDDKK',
'DOP':'USDDOP',
'DZD':'USDDZD',
'ECS':'USDECS',
'EEK':'USDEEK',
'EGP':'USDEGP',
'ERN':'USDERN',
'ESP':'USDESP',
'ETB':'USDETB',
'EUR':'EURUSD',
'FIM':'USDFIM',
'FJD':'FJDUSD',
'FKP':'FKPUSD',
'FRF':'USDFRF',
'GBP':'GBPUSD',
'GEL':'USDGEL',
'GHS':'USDGHS',
'GIP':'GIPUSD',
'GMD':'USDGMD',
'GNF':'USDGNF',
'GRD':'USDGRD',
'GTQ':'USDGTQ',
'GYD':'USDGYD',
'HKD':'USDHKD',
'HNL':'USDHNL',
'HRK':'USDHRK',
'HTG':'USDHTG',
'HUF':'USDHUF',
'IDR':'USDIDR',
'IEP':'IEPUSD',
'ILS':'USDILS',
'INR':'USDINR',
'IQD':'USDIQD',
'IRR':'USDIRR',
'ISK':'USDISK',
'ITL':'USDITL',
'JMD':'USDJMD',
'JOD':'USDJOD',
'JPY':'USDJPY',
'KES':'USDKES',
'KGS':'USDKGS',
'KHR':'USDKHR',
'KMF':'USDKMF',
'KPW':'USDKPW',
'KRW':'USDKRW',
'KWD':'USDKWD',
'KYD':'KYDUSD',
'KZT':'USDKZT',
'LAK':'USDLAK',
'LBP':'USDLBP',
'LKR':'USDLKR',
'LRD':'USDLRD',
'LSL':'USDLSL',
'LTL':'USDLTL',
'LUF':'USDLUF',
'LVL':'USDLVL',
'LYD':'USDLYD',
'MAD':'USDMAD',
'MDL':'USDMDL',
'MGA':'USDMGA',
'MKD':'USDMKD',
'MMK':'USDMMK',
'MNT':'USDMNT',
'MOP':'USDMOP',
'MRO':'USDMRO',
'MUR':'USDMUR',
'MVR':'USDMVR',
'MWK':'USDMWK',
'MXN':'USDMXN',
'MYR':'USDMYR',
'MZN':'USDMZN',
'NAD':'USDNAD',
'NGN':'USDNGN',
'NIO':'USDNIO',
'NLG':'USDNLG',
'NOK':'USDNOK',
'NPR':'USDNPR',
'NZD':'NZDUSD',
'OMR':'USDOMR',
'PAB':'USDPAB',
'PEN':'USDPEN',
'PGK':'PGKUSD',
'PHP':'USDPHP',
'PKR':'USDPKR',
'PLN':'USDPLN',
'PTE':'USDPTE',
'PYG':'USDPYG',
'QAR':'USDQAR',
'RON':'USDRON',
'RSD':'USDRSD',
'RUB':'USDRUB',
'RWF':'USDRWF',
'SAR':'USDSAR',
'SBD':'SBDUSD',
'SCR':'USDSCR',
'SDG':'USDSDG',
'SEK':'USDSEK',
'SGD':'USDSGD',
'SHP':'SHPUSD',
'SIT':'USDSIT',
'SKK':'USDSKK',
'SLL':'USDSLL',
'SOS':'USDSOS',
'SRD':'USDSRD',
'STD':'USDSTD',
'SVC':'USDSVC',
'SYP':'USDSYP',
'SZL':'USDSZL',
'THB':'USDTHB',
'TJS':'USDTJS',
'TMM':'USDTMM',
'TND':'USDTND',
'TOP':'TOPUSD',
'TRY':'USDTRY',
'TTD':'USDTTD',
'TWD':'USDTWD',
'TZS':'USDTZS',
'UAH':'USDUAH',
'UGX':'USDUGX',
'UYU':'USDUYU',
'UZS':'USDUZS',
'VEF':'USDVEF',
'VND':'USDVND',
'VUV':'USDVUV',
'WST':'WSTUSD',
'XAF':'USDXAF',
'XAG':'XAGUSD',
'XAU':'XAUUSD',
'XCD':'USDXCD',
'XOF':'USDXOF',
'XPD':'XPDUSD',
'XPF':'USDXPF',
'XPT':'XPTUSD',
'YER':'USDYER',
'ZAR':'USDZAR',
'ZMW':'USDZMW'
}

def get_currency_quote_convention(currency):
    return currency_quote_convention.get(str(currency).upper(),None)

def check_cross(pair):
    pair = str(pair).upper()
    for key, value in currency_quote_convention.items():
        if value == pair:
            return False
    return True
