"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codebuild = require("@aws-cdk/aws-codebuild");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
// tslint:disable:object-literal-key-quotes
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-codecommit-codebuild');
const repository = new codecommit.Repository(stack, 'MyRepo', {
    repositoryName: 'my-repo',
});
const sourceOutput = new codepipeline.Artifact('SourceArtifact');
const sourceAction = new cpactions.CodeCommitSourceAction({
    actionName: 'source',
    output: sourceOutput,
    repository,
    trigger: cpactions.CodeCommitTrigger.POLL,
});
const project = new codebuild.PipelineProject(stack, 'MyBuildProject');
const buildAction = new cpactions.CodeBuildAction({
    actionName: 'build',
    project,
    input: sourceOutput,
    outputs: [new codepipeline.Artifact()],
    environmentVariables: {
        'TEST_ENV_VARIABLE': {
            value: 'test env variable value',
        },
        'PARAM_STORE_VARIABLE': {
            value: 'param_store',
            type: codebuild.BuildEnvironmentVariableType.PARAMETER_STORE,
        },
    },
});
const testAction = new cpactions.CodeBuildAction({
    type: cpactions.CodeBuildActionType.TEST,
    actionName: 'test',
    project,
    input: sourceOutput,
});
new codepipeline.Pipeline(stack, 'Pipeline', {
    stages: [
        {
            stageName: 'source',
            actions: [sourceAction],
        },
    ],
}).addStage({
    stageName: 'build',
    actions: [
        buildAction,
        testAction,
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucGlwZWxpbmUtY29kZS1jb21taXQtYnVpbGQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5waXBlbGluZS1jb2RlLWNvbW1pdC1idWlsZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG9EQUFvRDtBQUNwRCxzREFBc0Q7QUFDdEQsMERBQTBEO0FBQzFELHFDQUFxQztBQUNyQyxvQ0FBb0M7QUFFcEMsMkNBQTJDO0FBRTNDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsMkNBQTJDLENBQUMsQ0FBQztBQUU5RSxNQUFNLFVBQVUsR0FBRyxJQUFJLFVBQVUsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtJQUM1RCxjQUFjLEVBQUUsU0FBUztDQUMxQixDQUFDLENBQUM7QUFDSCxNQUFNLFlBQVksR0FBRyxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztBQUNqRSxNQUFNLFlBQVksR0FBRyxJQUFJLFNBQVMsQ0FBQyxzQkFBc0IsQ0FBQztJQUN4RCxVQUFVLEVBQUUsUUFBUTtJQUNwQixNQUFNLEVBQUUsWUFBWTtJQUNwQixVQUFVO0lBQ1YsT0FBTyxFQUFFLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJO0NBQzFDLENBQUMsQ0FBQztBQUVILE1BQU0sT0FBTyxHQUFHLElBQUksU0FBUyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUN2RSxNQUFNLFdBQVcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxlQUFlLENBQUM7SUFDaEQsVUFBVSxFQUFFLE9BQU87SUFDbkIsT0FBTztJQUNQLEtBQUssRUFBRSxZQUFZO0lBQ25CLE9BQU8sRUFBRSxDQUFDLElBQUksWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ3RDLG9CQUFvQixFQUFFO1FBQ3BCLG1CQUFtQixFQUFFO1lBQ25CLEtBQUssRUFBRSx5QkFBeUI7U0FDakM7UUFDRCxzQkFBc0IsRUFBRTtZQUN0QixLQUFLLEVBQUUsYUFBYTtZQUNwQixJQUFJLEVBQUUsU0FBUyxDQUFDLDRCQUE0QixDQUFDLGVBQWU7U0FDN0Q7S0FDRjtDQUNGLENBQUMsQ0FBQztBQUNILE1BQU0sVUFBVSxHQUFHLElBQUksU0FBUyxDQUFDLGVBQWUsQ0FBQztJQUMvQyxJQUFJLEVBQUUsU0FBUyxDQUFDLG1CQUFtQixDQUFDLElBQUk7SUFDeEMsVUFBVSxFQUFFLE1BQU07SUFDbEIsT0FBTztJQUNQLEtBQUssRUFBRSxZQUFZO0NBQ3BCLENBQUMsQ0FBQztBQUVILElBQUksWUFBWSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO0lBQzNDLE1BQU0sRUFBRTtRQUNOO1lBQ0UsU0FBUyxFQUFFLFFBQVE7WUFDbkIsT0FBTyxFQUFFLENBQUMsWUFBWSxDQUFDO1NBQ3hCO0tBQ0Y7Q0FDRixDQUFDLENBQUMsUUFBUSxDQUFDO0lBQ1YsU0FBUyxFQUFFLE9BQU87SUFDbEIsT0FBTyxFQUFFO1FBQ1AsV0FBVztRQUNYLFVBQVU7S0FDWDtDQUNGLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVidWlsZCBmcm9tICdAYXdzLWNkay9hd3MtY29kZWJ1aWxkJztcbmltcG9ydCAqIGFzIGNvZGVjb21taXQgZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVjb21taXQnO1xuaW1wb3J0ICogYXMgY29kZXBpcGVsaW5lIGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2RlcGlwZWxpbmUnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY3BhY3Rpb25zIGZyb20gJy4uL2xpYic7XG5cbi8vIHRzbGludDpkaXNhYmxlOm9iamVjdC1saXRlcmFsLWtleS1xdW90ZXNcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstY29kZXBpcGVsaW5lLWNvZGVjb21taXQtY29kZWJ1aWxkJyk7XG5cbmNvbnN0IHJlcG9zaXRvcnkgPSBuZXcgY29kZWNvbW1pdC5SZXBvc2l0b3J5KHN0YWNrLCAnTXlSZXBvJywge1xuICByZXBvc2l0b3J5TmFtZTogJ215LXJlcG8nLFxufSk7XG5jb25zdCBzb3VyY2VPdXRwdXQgPSBuZXcgY29kZXBpcGVsaW5lLkFydGlmYWN0KCdTb3VyY2VBcnRpZmFjdCcpO1xuY29uc3Qgc291cmNlQWN0aW9uID0gbmV3IGNwYWN0aW9ucy5Db2RlQ29tbWl0U291cmNlQWN0aW9uKHtcbiAgYWN0aW9uTmFtZTogJ3NvdXJjZScsXG4gIG91dHB1dDogc291cmNlT3V0cHV0LFxuICByZXBvc2l0b3J5LFxuICB0cmlnZ2VyOiBjcGFjdGlvbnMuQ29kZUNvbW1pdFRyaWdnZXIuUE9MTCxcbn0pO1xuXG5jb25zdCBwcm9qZWN0ID0gbmV3IGNvZGVidWlsZC5QaXBlbGluZVByb2plY3Qoc3RhY2ssICdNeUJ1aWxkUHJvamVjdCcpO1xuY29uc3QgYnVpbGRBY3Rpb24gPSBuZXcgY3BhY3Rpb25zLkNvZGVCdWlsZEFjdGlvbih7XG4gIGFjdGlvbk5hbWU6ICdidWlsZCcsXG4gIHByb2plY3QsXG4gIGlucHV0OiBzb3VyY2VPdXRwdXQsXG4gIG91dHB1dHM6IFtuZXcgY29kZXBpcGVsaW5lLkFydGlmYWN0KCldLFxuICBlbnZpcm9ubWVudFZhcmlhYmxlczoge1xuICAgICdURVNUX0VOVl9WQVJJQUJMRSc6IHtcbiAgICAgIHZhbHVlOiAndGVzdCBlbnYgdmFyaWFibGUgdmFsdWUnLFxuICAgIH0sXG4gICAgJ1BBUkFNX1NUT1JFX1ZBUklBQkxFJzoge1xuICAgICAgdmFsdWU6ICdwYXJhbV9zdG9yZScsXG4gICAgICB0eXBlOiBjb2RlYnVpbGQuQnVpbGRFbnZpcm9ubWVudFZhcmlhYmxlVHlwZS5QQVJBTUVURVJfU1RPUkUsXG4gICAgfSxcbiAgfSxcbn0pO1xuY29uc3QgdGVzdEFjdGlvbiA9IG5ldyBjcGFjdGlvbnMuQ29kZUJ1aWxkQWN0aW9uKHtcbiAgdHlwZTogY3BhY3Rpb25zLkNvZGVCdWlsZEFjdGlvblR5cGUuVEVTVCxcbiAgYWN0aW9uTmFtZTogJ3Rlc3QnLFxuICBwcm9qZWN0LFxuICBpbnB1dDogc291cmNlT3V0cHV0LFxufSk7XG5cbm5ldyBjb2RlcGlwZWxpbmUuUGlwZWxpbmUoc3RhY2ssICdQaXBlbGluZScsIHtcbiAgc3RhZ2VzOiBbXG4gICAge1xuICAgICAgc3RhZ2VOYW1lOiAnc291cmNlJyxcbiAgICAgIGFjdGlvbnM6IFtzb3VyY2VBY3Rpb25dLFxuICAgIH0sXG4gIF0sXG59KS5hZGRTdGFnZSh7XG4gIHN0YWdlTmFtZTogJ2J1aWxkJyxcbiAgYWN0aW9uczogW1xuICAgIGJ1aWxkQWN0aW9uLFxuICAgIHRlc3RBY3Rpb24sXG4gIF0sXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=