# degiro-client
Unofficial Degiro API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 0.0.1a2.dev3
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://github.com/maximdeclercq/degiro-client](https://github.com/maximdeclercq/degiro-client)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/maximdeclercq/degiro-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/maximdeclercq/degiro-client.git`)

Then import the package:
```python
import degiro_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import degiro_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import degiro_client
from degiro_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: IntAccountAuth
configuration = degiro_client.Configuration()
configuration.api_key['intAccount'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['intAccount'] = 'Bearer'
# Configure API key authorization: SessionIdAuth
configuration = degiro_client.Configuration()
configuration.api_key['sessionId'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionId'] = 'Bearer'

# create an instance of the API class
api_instance = degiro_client.ConfigApi(degiro_client.ApiClient(configuration))

try:
    # Returns the config
    api_response = api_instance.config()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ConfigApi->config: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://trader.degiro.nl*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**config**](docs/ConfigApi.md#config) | **GET** /login/secure/config | Returns the config
*LoginApi* | [**login**](docs/LoginApi.md#login) | **POST** /login/secure/login | Logs in
*PaApi* | [**client**](docs/PaApi.md#client) | **GET** /pa/secure/client | Returns the client
*PaApi* | [**clienttasks**](docs/PaApi.md#clienttasks) | **GET** /pa/secure/clienttasks | Returns the client tasks
*PaApi* | [**clienttasks_taskmanager_count**](docs/PaApi.md#clienttasks_taskmanager_count) | **GET** /pa/secure/clienttasks/taskmanager/count | Returns the client tasks
*ProductSearchApi* | [**lookup**](docs/ProductSearchApi.md#lookup) | **GET** /product_search/secure/v5/products/lookup | TODO
*ReportingApi* | [**orderhistory**](docs/ReportingApi.md#orderhistory) | **GET** /reporting/secure/v4/order_history | TODO
*ReportingApi* | [**reporting**](docs/ReportingApi.md#reporting) | **GET** /reporting/secure/v4 | TODO
*SettingsApi* | [**beta_test**](docs/SettingsApi.md#beta_test) | **GET** /pa/secure/settings/beta-test | TODO
*SettingsApi* | [**iex**](docs/SettingsApi.md#iex) | **GET** /pa/secure/settings/iex | TODO
*SettingsApi* | [**user**](docs/SettingsApi.md#user) | **GET** /pa/secure/settings/user | TODO
*SettingsApi* | [**web**](docs/SettingsApi.md#web) | **GET** /pa/secure/settings/web | TODO
*TradingApi* | [**account_info**](docs/TradingApi.md#account_info) | **GET** /trading/secure/v5/account/info/{intAccount};jsessionid&#x3D;{sessionId} | TODO
*TradingApi* | [**check_order**](docs/TradingApi.md#check_order) | **POST** /trading/secure/v5/checkOrder;jsessionid&#x3D;{sessionId} | TODO
*TradingApi* | [**confirm_order**](docs/TradingApi.md#confirm_order) | **POST** /trading/secure/v5/order/{confirmationId};jsessionid&#x3D;{sessionId} | TODO
*TradingApi* | [**update**](docs/TradingApi.md#update) | **GET** /trading/secure/v5/update/{intAccount};jsessionid&#x3D;{sessionId} | TODO

## Documentation For Models

 - [Any](docs/Any.md)
 - [CheckOrderResponse](docs/CheckOrderResponse.md)
 - [CheckOrderResponseData](docs/CheckOrderResponseData.md)
 - [CheckOrderResponseDataTransactionFees](docs/CheckOrderResponseDataTransactionFees.md)
 - [ClientResponse](docs/ClientResponse.md)
 - [ClientResponseData](docs/ClientResponseData.md)
 - [ClientResponseDataAddress](docs/ClientResponseDataAddress.md)
 - [ClientResponseDataBankAccount](docs/ClientResponseDataBankAccount.md)
 - [ClientResponseDataFirstContact](docs/ClientResponseDataFirstContact.md)
 - [ConfigResponse](docs/ConfigResponse.md)
 - [ConfigResponseData](docs/ConfigResponseData.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2001Data](docs/InlineResponse2001Data.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2002Data](docs/InlineResponse2002Data.md)
 - [InlineResponse2002DataDesktop](docs/InlineResponse2002DataDesktop.md)
 - [InlineResponse2002DataMobile](docs/InlineResponse2002DataMobile.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2003Data](docs/InlineResponse2003Data.md)
 - [InlineResponse2003DataMarketPageChartIndex](docs/InlineResponse2003DataMarketPageChartIndex.md)
 - [InlineResponse2003DataMarketPageCurrencies](docs/InlineResponse2003DataMarketPageCurrencies.md)
 - [InlineResponse2003DataMarketPageFutures](docs/InlineResponse2003DataMarketPageFutures.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2004Products](docs/InlineResponse2004Products.md)
 - [InlineResponse200Data](docs/InlineResponse200Data.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [OneOfAny](docs/OneOfAny.md)
 - [OrderRequest](docs/OrderRequest.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [OrderResponseData](docs/OrderResponseData.md)
 - [UpdateResponse](docs/UpdateResponse.md)
 - [UpdateResponsePart](docs/UpdateResponsePart.md)
 - [UpdateResponsePartValue](docs/UpdateResponsePartValue.md)
 - [UpdateResponsePartValue1](docs/UpdateResponsePartValue1.md)

## Documentation For Authorization


## IntAccountAuth

- **Type**: API key
- **API key parameter name**: intAccount
- **Location**: URL query string

## SessionIdAuth

- **Type**: API key
- **API key parameter name**: sessionId
- **Location**: URL query string


## Author

maximdeclercq00@gmail.com
