"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasOutput = exports.findOutputs = void 0;
const section_1 = require("./section");
function findOutputs(template, logicalId, props = {}) {
    const section = template.Outputs ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findOutputs = findOutputs;
function hasOutput(template, logicalId, props) {
    const section = template.Outputs ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No outputs named ${logicalId} found in the template (found: ${Object.keys(section).join(', ')})`;
    }
    return [
        `Template has ${result.analyzedCount} outputs named ${logicalId}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasOutput = hasOutput;
//# sourceMappingURL=data:application/json;base64,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