# Logging
from roguewave.log import logger
from roguewave.tools.time import to_datetime_utc, to_datetime64

# model time
from roguewave.modeldata import (
    TimeSliceLead,
    timebase_forecast,
    TimeSliceForecast,
    TimeSliceEvaluation,
    TimeSliceAnalysis,
    model_timebase,
    model_valid_time,
    available_models,
    list_available_variables,
    open_remote_dataset,
    extract_from_remote_dataset,
    generate_uris,
)


# Interpolate
from roguewave.interpolate import (
    interpolate_dataset,
    tracks_as_dataset,
    TrackSet,
    Track,
    Cluster,
)

# Wave spectrum
from roguewave.wavespectra import (
    FrequencySpectrum,
    FrequencyDirectionSpectrum,
    create_1d_spectrum,
    create_2d_spectrum,
    concatenate_spectra,
    load_spectrum_from_netcdf,
)

# IO
from .io.io import save, load

# Restart Files:
from roguewave.wavewatch3 import (
    RestartFile,
    open_restart_file,
    write_partial_restart_file,
    write_restart_file,
    reassemble_restart_file_from_parts,
    unpack_ww3_data,
    read_model_definition,
)

# Partitioning
from roguewave.wavespectra.partitioning import (
    get_bulk_partitions_from_spectral_partitions,
    get_spectral_partitions_from_2dspectra,
    get_bulk_partitions_from_observations,
    get_spectral_partitions_from_observations,
)

# Colocation
from roguewave.colocate import (
    colocate_model_spotter,
    colocated_tracks_as_dataset,
    colocate_model_spotter_spectra,
)

from roguewave.spotterapi import get_spotter_data
