![logo](./docs/_static/logo.png) Welcome to Locan
==================================================

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5722472.svg)](https://doi.org/10.5281/zenodo.5722472)
[![PyPI](https://img.shields.io/pypi/v/locan)](https://pypi.org/project/locan/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/locan)](https://www.python.org/)
[![GitHub release (latest by date)](https://img.shields.io/github/v/release/super-resolution/locan)](https://github.com/super-resolution/Locan)
[![GitHub last commit](https://img.shields.io/github/last-commit/super-resolution/locan)](https://github.com/super-resolution/Locan/commits/main)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Tests](https://github.com/super-resolution/Locan/actions/workflows/Test_matrix_pip.yml/badge.svg?branch=main)](https://github.com/super-resolution/Locan/actions/workflows/Test_matrix_pip.yml)
[![codecov](https://codecov.io/gh/super-resolution/Locan/branch/main/graph/badge.svg?token=XTZRIIVOGE)](https://codecov.io/gh/super-resolution/Locan)
[![Documentation Status](https://readthedocs.org/projects/locan/badge/?version=latest)](https://locan.readthedocs.io/en/latest/?badge=latest)


Locan is a python-based library with code for analyzing fluorescence super-resolution
microscopy data.

Getting Started
----------------

To install the package please read the [instructions](https://locan.readthedocs.io/en/latest/source/installation.html) or:

    pip install locan

For details on usage and development please read the [documentation](https://locan.readthedocs.io).

[Tutorials](https://locan.readthedocs.io/en/latest/tutorials/tutorials.html) are provided as Jupyter notebooks.

You can use the package in a docker container as described in [docker/README.md](docker/README.md).

Contributing
------------

Development takes place on the [Locan GitHub page](https://github.com/super-resolution/Locan).

Please use [GitHub issues](https://github.com/super-resolution/Locan/issues) to report bugs and feature requests. 
Use [GitHub discussions](https://github.com/super-resolution/Locan/discussions) for Q&A.

Please read [documentation on development](https://locan.readthedocs.io/en/latest/source/development.html) for details on how to help develop this project further.

Developers
----------

See the list of [contributors](https://locan.readthedocs.io/en/latest/source/contributions.html) who participated in this project.

License
-------

This project is licensed under the BSD-3 License - see the [LICENSE](LICENSE.md) file for details.

Citing
-------

If you want to acknowledge locan please cite the following publication:

Sören Doose, LOCAN: a python library for analyzing single-molecule localization microscopy data, Bioinformatics 38(9), 2670–2672, 2022,
https://doi.org/10.1093/bioinformatics/btac160

Or cite this repository using the DOI provided by zenodo:

[doi.org/10.5281/zenodo.5722472](https://doi.org/10.5281/zenodo.5722472)

Note this DOI will resolve to all versions of locan. 
To cite a specific version please find the DOI of that version on the zenodo page. 
