"""HTML constants."""

# See https://html.spec.whatwg.org/#elements-3.
ELEMENTS = {
    "a",
    "abbr",
    "address",
    "area",
    "article",
    "aside",
    "audio",
    "b",
    "base",
    "bdi",
    "bdo",
    "blockquote",
    "body",
    "br",
    "button",
    "canvas",
    "caption",
    "cite",
    "code",
    "col",
    "colgroup",
    "data",
    "datalist",
    "dd",
    "del",
    "details",
    "dfn",
    "dialog",
    "div",
    "dl",
    "dt",
    "em",
    "embed",
    "fieldset",
    "figcaption",
    "figure",
    "footer",
    "form",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hr",
    "html",
    "i",
    "iframe",
    "img",
    "input",
    "ins",
    "kbd",
    "label",
    "legend",
    "li",
    "link",
    "main",
    "map",
    "mark",
    "math",
    "menu",
    "meta",
    "meter",
    "nav",
    "noscript",
    "object",
    "ol",
    "optgroup",
    "option",
    "output",
    "p",
    "picture",
    "portal",
    "pre",
    "progress",
    "q",
    "rp",
    "rt",
    "ruby",
    "s",
    "samp",
    "script",
    "section",
    "select",
    "slot",
    "small",
    "source",
    "span",
    "strong",
    "style",
    "sub",
    "summary",
    "sup",
    "svg",
    "table",
    "tbody",
    "td",
    "template",
    "textarea",
    "tfoot",
    "th",
    "thead",
    "time",
    "title",
    "tr",
    "track",
    "u",
    "ul",
    "var",
    "video",
    "wbr",
}

# See https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes.
ATTR_TO_ELEMENTS = {
    "accept": {"form", "input"},
    "accept-charset": {"form"},
    "accesskey": ELEMENTS,
    "action": {"form"},
    "align": {
        "applet",
        "caption",
        "col",
        "colgroup",
        "hr",
        "iframe",
        "img",
        "table",
        "tbody",
        "td",
        "tfoot",
        "th",
        "thead",
        "tr",
    },
    "allow": {"iframe"},
    "alt": {"applet", "area", "img", "input"},
    "async": {"script"},
    "autocapitalize": ELEMENTS,
    "autocomplete": {"form", "input", "select", "textarea"},
    "autofocus": {"button", "input", "keygen", "select", "textarea"},
    "autoplay": {"audio", "video"},
    "background": {"body", "table", "td", "th"},
    "bgcolor": {
        "body",
        "col",
        "colgroup",
        "marquee",
        "table",
        "tbody",
        "tfoot",
        "td",
        "th",
        "tr",
    },
    "border": {"img", "object", "table"},
    "buffered": {"audio", "video"},
    "capture": {"input"},
    "challenge": {"keygen"},
    "charset": {"meta", "script"},
    "checked": {"input"},
    "cite": {"blockquote", "del", "ins", "q"},
    "class": ELEMENTS,
    "code": {"applet"},
    "codebase": {"applet"},
    "color": {"font", "hr"},
    "cols": {"textarea"},
    "colspan": {"td", "th"},
    "content": {"meta"},
    "contenteditable": ELEMENTS,
    "contextmenu": ELEMENTS,
    "controls": {"audio", "video"},
    "coords": {"area"},
    "crossorigin": {"audio", "img", "link", "script", "video"},
    "csp": {"iframe"},
    "data": {"object"},
    "datetime": {"del", "ins", "time"},
    "decoding": {"img"},
    "default": {"track"},
    "defer": {"script"},
    "dir": ELEMENTS,
    "dirname": {"input", "textarea"},
    "disabled": {
        "button",
        "fieldset",
        "input",
        "keygen",
        "optgroup",
        "option",
        "select",
        "textarea",
    },
    "download": {"a", "area"},
    "draggable": ELEMENTS,
    "enctype": {"form"},
    "enterkeyhint": ELEMENTS,
    "for": {"label", "output"},
    "form": {
        "button",
        "fieldset",
        "input",
        "keygen",
        "label",
        "meter",
        "object",
        "output",
        "progress",
        "select",
        "textarea",
    },
    "formaction": {"button", "input"},
    "formenctype": {"button", "input"},
    "formmethod": {"button", "input"},
    "formnovalidate": {"button", "input"},
    "formtarget": {"button", "input"},
    "headers": {"td", "th"},
    "height": {"canvas", "embed", "iframe", "img", "input", "object", "video"},
    "hidden": ELEMENTS,
    "high": {"meter"},
    "href": {"a", "area", "base", "link"},
    "hreflang": {"a", "area", "link"},
    "http-equiv": {"meta"},
    "icon": {"command"},
    "id": ELEMENTS,
    "integrity": {"link", "script"},
    "intrinsicsize": {"img"},
    "inputmode": ELEMENTS,
    "ismap": {"img"},
    "itemprop": ELEMENTS,
    "keytype": {"keygen"},
    "kind": {"track"},
    "label": {"optgroup", "option", "track"},
    "lang": ELEMENTS,
    "language": {"script"},
    "loading": {"img", "iframe"},
    "list": {"input"},
    "loop": {"audio", "bgsound", "marquee", "video"},
    "low": {"meter"},
    "manifest": {"html"},
    "max": {"input", "meter", "progress"},
    "maxlength": {"input", "textarea"},
    "minlength": {"input", "textarea"},
    "media": {"a", "area", "link", "source", "style"},
    "method": {"form"},
    "min": {"input", "meter"},
    "multiple": {"input", "select"},
    "muted": {"audio", "video"},
    "name": {
        "button",
        "form",
        "fieldset",
        "iframe",
        "input",
        "keygen",
        "object",
        "output",
        "select",
        "textarea",
        "map",
        "meta",
        "param",
    },
    "novalidate": {"form"},
    "open": {"details", "dialog"},
    "optimum": {"meter"},
    "pattern": {"input"},
    "ping": {"a", "area"},
    "placeholder": {"input", "textarea"},
    "playsinline": {"video"},
    "poster": {"video"},
    "preload": {"audio", "video"},
    "readonly": {"input", "textarea"},
    "referrerpolicy": {"a", "area", "iframe", "img", "link", "script"},
    "rel": {"a", "area", "link"},
    "required": {"input", "select", "textarea"},
    "reversed": {"ol"},
    "role": ELEMENTS,
    "rows": {"textarea"},
    "rowspan": {"td", "th"},
    "sandbox": {"iframe"},
    "scope": {"th"},
    "scoped": {"style"},
    "selected": {"option"},
    "shape": {"a", "area"},
    "size": {"input", "select"},
    "sizes": {"link", "img", "source"},
    "slot": ELEMENTS,
    "span": {"col", "colgroup"},
    "spellcheck": ELEMENTS,
    "src": {
        "audio",
        "embed",
        "iframe",
        "img",
        "input",
        "script",
        "source",
        "track",
        "video",
    },
    "srcdoc": {"iframe"},
    "srclang": {"track"},
    "srcset": {"img", "source"},
    "start": {"ol"},
    "step": {"input"},
    "style": ELEMENTS,
    "summary": {"table"},
    "tabindex": ELEMENTS,
    "target": {"a", "area", "base", "form"},
    "title": ELEMENTS,
    "translate": ELEMENTS,
    "type": {
        "button",
        "input",
        "embed",
        "object",
        "ol",
        "script",
        "source",
        "style",
        "menu",
        "link",
    },
    "usemap": {"img", "input", "object"},
    "value": {
        "button",
        "data",
        "input",
        "li",
        "meter",
        "option",
        "progress",
        "param",
    },
    "width": {"canvas", "embed", "iframe", "img", "input", "object", "video"},
    "wrap": {"textarea"},
}
